/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.sjb.cms.service.api;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.sjb.cms.utils.TCommon;
import kd.ebg.receipt.banks.sjb.cms.utils.TPacker;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import org.jdom2.Element;

public class Receipt529762Impl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    public String pack(BankReceiptRequest bankReceiptRequest) {
        Element ap = TPacker.createCommonHead("529762", Sequence.gen16Sequence(), "1");
        Element body = JDomUtils.addChild((Element)ap, (String)"body");
        BankAcnt acnt = bankReceiptRequest.getAcnt();
        JDomUtils.addChild((Element)body, (String)"acno", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)acnt.getCurrency());
        JDomUtils.addChild((Element)body, (String)"file_name", (String)bankReceiptRequest.getRequestStr());
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)encoding);
        try {
            return TCommon.createCommonMsg(xmlMsg, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String s) {
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)s, (String)encoding);
        Element head = ap.getChild("head");
        BankResponse response = TCommon.parseBankResponse(head);
        Element body = ap.getChild("body");
        if (!"0_0000".equalsIgnoreCase(response.getResponseCode()) || body == null || JDomUtils.getChildText((Element)body, (String)"stat").equalsIgnoreCase("6")) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5168\u6e20\u9053\u7535\u5b50\u56de\u5355\u4e0b\u8f7d\u8bf7\u6c42\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s\uff0c%2$s\u3002", (String)"Receipt529762Impl_0", (String)"ebg-receipt-banks-sjb-cms", (Object[])new Object[0]), response.getResponseCode(), response.getResponseMessage()));
        }
        String file_name = JDomUtils.getChildText((Element)body, (String)"file_name");
        return BankReceiptResponseEB.success((Object)file_name);
    }

    public String getDeveloper() {
        return "567";
    }

    public String getBizCode() {
        return "529762";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"3.26\u5168\u6e20\u9053\u7535\u5b50\u56de\u5355\u4e0b\u8f7d (529762\u4ea4\u6613)\u3002", (String)"Receipt529762Impl_1", (String)"ebg-receipt-banks-sjb-cms", (Object[])new Object[0]);
    }

    public String recv(InputStream inputStream) {
        return TCommon.parseRecvMsg(super.recv(inputStream));
    }
}

