/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bjb.dc.service.receipt.api;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.bjb.dc.service.receipt.login.LoginImpl;
import kd.ebg.receipt.banks.bjb.dc.service.util.PackerUtil;
import kd.ebg.receipt.banks.bjb.dc.service.util.ParserUtil;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import org.jdom2.Element;

public class BankReceiptInfoRequestImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptInfoRequestImpl.class);

    public String pack(BankReceiptRequest bankReceiptRequest) {
        String accNo = bankReceiptRequest.getAccNo();
        LocalDate transDate = bankReceiptRequest.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        Element root = new Element("BCCBEBankData");
        Element head = PackerUtil.createRequestHead("CebankQueryBillNumOp", Sequence.genSequence());
        Element param = JDomUtils.addChild((Element)head, (String)"ReqParam");
        JDomUtils.addChild((Element)param, (String)"accountNo", (String)accNo);
        JDomUtils.addChild((Element)param, (String)"billNumber", (String)"");
        JDomUtils.addChild((Element)param, (String)"beginDate", (String)transDateStr);
        JDomUtils.addChild((Element)param, (String)"endDate", (String)transDateStr);
        JDomUtils.addChild((Element)param, (String)"beginAmt", (String)"0.00");
        JDomUtils.addChild((Element)param, (String)"endAmt", (String)"999999999999.00");
        int currentPage = Integer.parseInt(this.getCurrentPage());
        JDomUtils.addChild((Element)param, (String)"turnPageBeginPos", (String)String.valueOf(currentPage * 999 + 1));
        JDomUtils.addChild((Element)param, (String)"turnPageShowNum", (String)String.valueOf(999));
        JDomUtils.addChild((Element)root, (Element)head);
        String requestStr = PackerUtil.joinRequest(root, "CebankQueryBillNumOp");
        return requestStr;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)"GB18030");
        BankResponse bankResponse = ParserUtil.parserRep(root);
        Preconditions.checkState((boolean)"0".equalsIgnoreCase(bankResponse.getResponseCode()), (Object)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u94f6\u884c\u8fd4\u56de\u7801:%1$s,\u9519\u8bef\u4fe1\u606f:%2$s", (String)"BankReceiptInfoRequestImpl_1", (String)"ebg-receipt-banks-bjb-dc", (Object[])new Object[0]), bankResponse.getResponseCode(), bankResponse.getResponseMessage()));
        Element opReq = JDomUtils.getUnNullChildElement((Element)root, (String)"opRep");
        Element opResult = JDomUtils.getUnNullChildElement((Element)opReq, (String)"opResult");
        Element resultSet = JDomUtils.getUnNullChildElement((Element)opReq, (String)"opResultSet");
        List result = resultSet.getChildren("opResult");
        String turnPageTotalNumStr = JDomUtils.getUnNullChildText((Element)opResult, (String)"turnPageTotalNum");
        int turnPageTotalNum = Integer.parseInt(turnPageTotalNumStr);
        int currentPage = Integer.parseInt(this.getCurrentPage());
        if (turnPageTotalNum <= (currentPage + 1) * 999 || result.isEmpty()) {
            this.setLastPage(true);
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        result.forEach(element -> {
            String billNumber = JDomUtils.getUnNullChildText((Element)element, (String)"billNumber");
            String kernelNum = JDomUtils.getUnNullChildText((Element)element, (String)"kernelNum");
            String amount = JDomUtils.getUnNullChildText((Element)element, (String)"amount");
            String lendingDirection = JDomUtils.getUnNullChildText((Element)element, (String)"lendingDirection");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("serialNo", (Object)kernelNum);
            jsonObject.put("amount", (Object)amount);
            jsonObject.put("cdFlag", (Object)lendingDirection);
            resultMap.put(billNumber, jsonObject);
        });
        return BankReceiptResponseEB.success((Object)resultMap);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "CebankQueryBillNumOp";
    }

    public String getBizDesc() {
        return "";
    }

    public void configFactory(ConnectionFactory factory) {
        LoginImpl.getInstance().configFactoryForSession(factory, false);
    }

    public static Map<String, JSONObject> queryReceiptList(String accNo, LocalDate transDate) {
        BankReceiptInfoRequestImpl bankReceiptInfoRequest = new BankReceiptInfoRequestImpl();
        bankReceiptInfoRequest.setCurrentPage("0");
        bankReceiptInfoRequest.setLastPage(false);
        HashMap receiptResponseEBData = Maps.newHashMapWithExpectedSize((int)16);
        while (!bankReceiptInfoRequest.isLastPage()) {
            BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().transDate(transDate).accNo(accNo).build();
            BankReceiptResponseEB bankReceiptResponseEB = bankReceiptInfoRequest.doBiz(bankReceiptRequest);
            Map responseEBData = (Map)bankReceiptResponseEB.getData();
            int currentPage = Integer.parseInt(bankReceiptInfoRequest.getCurrentPage());
            bankReceiptInfoRequest.setCurrentPage(currentPage + 1);
            receiptResponseEBData.putAll(responseEBData);
        }
        return receiptResponseEBData;
    }
}

