/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.boimc.dc.receipt.api;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.receipt.banks.boimc.dc.receipt.BoimcDcCommConfig;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.receipt.bank.BankLoginProperties;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class B2EQueryImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    public String pack(BankReceiptRequest bankReceiptRequest) {
        Element message = new Element("Message");
        Element head = new Element("Head");
        JDomExtUtils.addChild((Element)message, (Element)head);
        JDomExtUtils.addChild((Element)head, (String)"TrsCode", (String)"B2EQueryBill");
        JDomExtUtils.addChild((Element)head, (String)"ERPTrsTimestamp", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        JDomExtUtils.addChild((Element)head, (String)"ERPJnlNo", (String)(Sequence.getInstance() + ""));
        Element body = new Element("Body");
        JDomExtUtils.addChild((Element)message, (Element)body);
        JDomExtUtils.addChild((Element)body, (String)"AcNo", (String)bankReceiptRequest.getAccNo());
        JDomExtUtils.addChild((Element)body, (String)"QueryDate", (String)bankReceiptRequest.getTransDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        return JDomExtUtils.doc2StrGBK((Document)new Document(message));
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String rsp) {
        Document doc = JDomExtUtils.str2DocGBK((String)rsp);
        Element root = doc.getRootElement();
        Element Head = JDomExtUtils.getChildElement((Element)root, (String)"Head");
        if (Head == null) {
            return null;
        }
        String returnCode = JDomExtUtils.getUnNullChildTextTrim((Element)Head, (String)"IBSReturnCode");
        String returnMsg = JDomExtUtils.getUnNullChildTextTrim((Element)Head, (String)"IBSReturnMsg");
        if (!"000000".equals(returnCode)) {
            return null;
        }
        Element Elementbody = JDomExtUtils.getChildElement((Element)root, (String)"Body");
        Element list = JDomExtUtils.getChildElement((Element)Elementbody, (String)"List");
        List children = list.getChildren();
        Element child = null;
        ArrayList<String> ar = new ArrayList<String>(16);
        for (int i = 0; i < children.size(); ++i) {
            child = (Element)children.get(i);
            ar.add(JDomExtUtils.getUnNullChildTextTrim((Element)child, (String)"BillName"));
        }
        return BankReceiptResponseEB.success(ar);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        String bankLoginId = EBContext.getContext().getBankLoginID();
        BankLoginProperties bankLoginProperties = (BankLoginProperties)EBConfigBuilder.getInstance().buildConfig(BankLoginProperties.class, bankLoginId);
        String url = "http://" + bankLoginProperties.getIp() + ":" + bankLoginProperties.getPort() + "/eweb/B2EQueryBill.do?userPassword=" + ((BoimcDcCommConfig)EBConfigBuilder.getInstance().buildConfig(BoimcDcCommConfig.class, bankLoginId)).getUserCipher() + "&SIGDATA=1";
        factory.setUri(url);
    }
}

