/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.nhb.dc.receipt.service.api;

import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.nhb.dc.receipt.service.api.DetailPage;
import kd.ebg.receipt.banks.nhb.dc.receipt.service.utils.Packer;
import kd.ebg.receipt.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.receipt.business.detail.atomic.IDetail;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.common.framework.match.MatchRule;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail {
    public String pack(BankDetailRequest rqst) {
        Element root = JDomUtils.createRoot((String)"Message");
        Element head = Packer.createHead("B2EActTrsQry");
        JDomUtils.addChild((Element)root, (Element)head);
        String pageTag = this.getCurrentPage();
        if (StringUtils.isEmpty((String)pageTag) || Objects.equals("0", pageTag)) {
            pageTag = "1";
            this.setCurrentPage(pageTag);
        }
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"AcNo", (String)rqst.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"BeginDate", (String)rqst.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"EndDate", (String)rqst.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"AcSub", (String)"");
        JDomUtils.addChild((Element)body, (String)"BeginNo", (String)pageTag);
        JDomUtils.addChild((Element)body, (String)"RecordNum", (String)"100");
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String rspStr) {
        this.setLastPage(true);
        DetailPage dp = new DetailPage();
        if (dp.isLastPage(rspStr)) {
            this.setLastPage(true);
        } else {
            int intPageTag = Integer.parseInt(this.getCurrentPage());
            int intPageSize = Integer.parseInt("100");
            this.setCurrentPage(String.valueOf(intPageTag + intPageSize));
            this.setLastPage(false);
        }
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        EBBankDetailResponse ebBankDetailResponse = new EBBankDetailResponse();
        Element root = JDomUtils.string2Root((String)rspStr, (String)EBContext.getContext().getCharsetName());
        Element head = root.getChild("Head");
        String iBSReturnCode = head.getChildTextTrim("IBSReturnCode");
        String iBSReturnMsg = head.getChildTextTrim("IBSReturnMsg");
        if (!"000000".equals(iBSReturnCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"DetailImpl_4", (String)"ebg-receipt-banks-nhb-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{iBSReturnCode, iBSReturnMsg})));
        }
        Element body = root.getChild("Body");
        Element list = body.getChild("List");
        if (null == list) {
            ebBankDetailResponse.setDetails(detailList);
            return ebBankDetailResponse;
        }
        List maps = list.getChildren();
        if (null == maps || maps.size() < 1) {
            ebBankDetailResponse.setDetails(detailList);
            return ebBankDetailResponse;
        }
        BankAcnt acnt = bankDetailRequest.getAcnt();
        for (int i = 0; i < maps.size(); ++i) {
            Element map = (Element)maps.get(i);
            String fromAcNo = map.getChildTextTrim("FromAcNo");
            String transDate = map.getChildTextTrim("TransactionDate");
            String amount = map.getChildTextTrim("Amount");
            String SerialNo = map.getChildTextTrim("SerialNo");
            if (StringUtils.isEmpty((String)amount)) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u4ea4\u6613\u91d1\u989d\u4e3a\u7a7a,Amount=%s", (String)"DetailImpl_5", (String)"ebg-receipt-banks-nhb-dc", (Object[])new Object[0]), amount));
            }
            DetailInfo detail = new DetailInfo();
            detail.setCurrency(bankDetailRequest.getBankCurrency());
            detail.setAccNo(acnt.getAccNo());
            detail.setAccName(acnt.getAccName());
            detail.setBankName(acnt.getBankName());
            detail.setOppAccNo(fromAcNo);
            if (amount.startsWith("-")) {
                detail.setDebitAmount(new BigDecimal(amount.replace("-", "")));
            } else {
                detail.setCreditAmount(new BigDecimal(amount));
            }
            detail.setReversed1(amount);
            if (StringUtils.isEmpty((String)transDate)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff1a\u94f6\u884c\u672a\u63d0\u4f9b\u4ea4\u6613\u65e5\u671f<TransDate>\u3002\u8bf7\u8054\u7cfb\u94f6\u884c\u5904\u7406\u3002", (String)"DetailImpl_2", (String)"ebg-receipt-banks-nhb-dc", (Object[])new Object[0]));
            }
            detail.setReceiptNo(SerialNo);
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(map);
            detail.setJson(jsonStr);
            detailList.add(detail);
        }
        ebBankDetailResponse.setDetails(detailList);
        return ebBankDetailResponse;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "B2EActTrsQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u666e\u901a\u8d26\u6237\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u3002\u5f53\u65e5\u660e\u7ec6\u548c\u5386\u53f2\u660e\u7ec6\u91c7\u7528\u540c\u4e00\u4e2a\u63a5\u53e3\u3002", (String)"DetailImpl_3", (String)"ebg-receipt-banks-nhb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri(Packer.getUrl(this.getBizCode()));
    }

    public boolean isSupportPage() {
        return true;
    }

    public int getFirstPage() {
        return 1;
    }
}

