/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.nhb.dc.receipt.service.download;

import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.nhb.dc.receipt.service.api.ReceiptPrintApi;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class ReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "RECEIPT_DOWNLOAD";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(1);
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"NHB_DC", (String)accNo, (String)transDateStr);
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).build();
        ReceiptPrintApi receiptPrintApi = new ReceiptPrintApi();
        ArrayList<Long> deleteIds = new ArrayList<Long>(1);
        for (DownloadListDetail downloadListDetail : downloadListDetails) {
            if (downloadListDetail.getUploadFlag().intValue() == UploadStatusEnum.UPLOAD_SUCCESS.getId()) {
                result.add(downloadListDetail);
                continue;
            }
            String fileLink = downloadListDetail.getFileLink();
            String fileName = downloadListDetail.getFileName();
            try {
                bankReceiptRequest.setRequestStr(fileLink);
                BankReceiptResponseEB receiptResponseEB = receiptPrintApi.doBiz(bankReceiptRequest);
                if (receiptResponseEB.getCode() == BankReceiptResponseEB.ResultEnum.SUCCESS.getCode()) {
                    String base64Str = (String)receiptResponseEB.getData();
                    if (FileCommonUtils.base64ToFile((String)base64Str, (String)(bakFilePath + File.separator + fileName))) {
                        result.add(downloadListDetail);
                        continue;
                    }
                    throw new ReceiptException(ResManager.loadKDString((String)"base64\u8f6c\u6362\u6210\u6587\u4ef6\u5931\u8d25\u3002", (String)"ReceiptDownloadImpl_0", (String)"ebg-receipt-banks-nhb-dc", (Object[])new Object[0]));
                }
                throw new ReceiptException(receiptResponseEB.getMessage());
            }
            catch (Throwable e) {
                deleteIds.add(downloadListDetail.getId());
                logger.error("\u5355\u6761\u56de\u5355\u4e0b\u8f7d\u5931\u8d25-\u6d41\u6c34\u53f7\uff1a{}-\u5931\u8d25\u539f\u56e0\uff1a{}", new Object[]{fileLink, e.getMessage(), e});
            }
        }
        this.downloadListDetailService.deleteById(deleteIds);
        return BankReceiptHandleResponseEB.success(result);
    }
}

