/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.nhb.dc.receipt.service.fetch;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.nhb.dc.receipt.service.api.DetailImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class ReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "RECEIPT_FETCHLIST";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(1);
        DetailImpl detailImpl = new DetailImpl();
        List queryTransDetail = detailImpl.queryTransDetail(accNo, transDate, transDate);
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().transDate(request.getTransDate()).accNo(request.getAccNo()).build();
        if (queryTransDetail.isEmpty()) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u6ca1\u6709\u56de\u5355\u8bb0\u5f55", (String)"ReceiptFetchListImpl_0", (String)"ebg-receipt-banks-bbgb-dc", (Object[])new Object[0]));
        }
        for (DetailInfo detailInfo : queryTransDetail) {
            String hostFlowNo = detailInfo.getReceiptNo();
            String amount = detailInfo.getReversed1();
            String oppAccNo = detailInfo.getOppAccNo();
            if (EBGStringUtils.isEmpty((String)oppAccNo)) {
                oppAccNo = "e";
            }
            DownloadListDetail downloadListDetail = new DownloadListDetail();
            StringBuilder fileName = new StringBuilder();
            fileName.append(accNo).append("_");
            fileName.append(transDateStr).append("_");
            fileName.append(hostFlowNo).append("_");
            fileName.append(amount).append("_");
            fileName.append(oppAccNo).append("_");
            fileName.append(".pdf");
            String receiptName = fileName.toString();
            downloadListDetail.setFileLink(hostFlowNo);
            downloadListDetail.setFileName(receiptName);
            downloadListDetail.setReceiptJson(detailInfo.getJson());
            result.add(downloadListDetail);
        }
        return BankReceiptHandleResponseEB.success(result);
    }
}

