/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ceb.dc.service.receipt;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.ceb.dc.service.CebDCCommConfig;
import kd.ebg.receipt.banks.ceb.dc.service.receipt.api.BankReceiptInfoQueryImpl;
import kd.ebg.receipt.banks.ceb.dc.service.receipt.api.BankReceiptNameQueryImpl;
import kd.ebg.receipt.banks.ceb.dc.service.receipt.api.OneBankReceiptQueryImpl;
import kd.ebg.receipt.banks.ceb.dc.service.receipt.api.ofd.BankReceiptFileAppointmentImpl;
import kd.ebg.receipt.banks.ceb.dc.service.receipt.util.pdf.ResponseParser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        String bankLoginId = request.getBankLoginId();
        LocalDate transDate = request.getTransDate();
        String localDate = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String accNo = request.getAccNo();
        CebDCCommConfig config = (CebDCCommConfig)EBConfigBuilder.getInstance().buildConfig(CebDCCommConfig.class, bankLoginId);
        boolean isPdf = config.getReceiptFileType().equals("PDF");
        RequestContextUtils.setRunningParam((String)"cipher", (String)config.getCipher());
        RequestContextUtils.setRunningParam((String)"cifNo", (String)config.getCifNo());
        RequestContextUtils.setRunningParam((String)"userId", (String)config.getUserID());
        ArrayList<DownloadListDetail> detailList = new ArrayList<DownloadListDetail>(16);
        if (isPdf) {
            DownloadListDetail detail = null;
            int searchCount = 1;
            boolean hasNextPage = false;
            HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
            do {
                ArrayList<Map<String, String>> mapList = new ArrayList<Map<String, String>>(16);
                HashMap paramsMap = Maps.newHashMapWithExpectedSize((int)8);
                paramsMap.put("searchCount", searchCount);
                BankReceiptRequest receiptRequest = BankReceiptRequest.builder().paramsMap((Map)paramsMap).accNo(accNo).transDate(transDate).build();
                BankReceiptInfoQueryImpl iBankReceipt = new BankReceiptInfoQueryImpl();
                BankReceiptResponseEB receiptResponseEB = (BankReceiptResponseEB)iBankReceipt.doBiz((BankRequest)receiptRequest);
                String detailResponse = (String)receiptResponseEB.getData();
                hasNextPage = ResponseParser.detailParser(detailResponse, mapList, searchCount);
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException e) {
                    logger.error("\u5149\u5927\u94f6\u884c\u56de\u5355\u67e5\u8be2\u4f11\u7720\u5f02\u5e38", (Throwable)e);
                }
                Map map = null;
                for (int i = 0; i < mapList.size(); ++i) {
                    map = (Map)mapList.get(i);
                    String billNumber = (String)map.get("BillNumber");
                    HashMap paramMap = Maps.newHashMapWithExpectedSize((int)8);
                    paramMap.put("billNumber", billNumber);
                    BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().paramsMap((Map)paramMap).accNo(accNo).transDate(transDate).build();
                    if (Objects.equals(config.getShow_receipt_query_code(), "true") || FileCommonUtils.isTestEnv()) {
                        OneBankReceiptQueryImpl oneBankReceiptQuery = new OneBankReceiptQueryImpl();
                        oneBankReceiptQuery.doBiz(bankReceiptRequest);
                    }
                    BankReceiptNameQueryImpl bankReceiptNameQuery = new BankReceiptNameQueryImpl();
                    String filename = (String)((BankReceiptResponseEB)bankReceiptNameQuery.doBiz((BankRequest)bankReceiptRequest)).getData();
                    String newFileName = accNo + "_" + localDate + "_" + (String)map.get("FlowNumber") + "_" + (String)map.get("Amount") + ".pdf";
                    String flowNumber = (String)map.get("FlowNumber");
                    if (countMap.containsKey(flowNumber)) {
                        Integer recount = (Integer)countMap.get(flowNumber);
                        recount = recount + 1;
                        StringBuilder newFileBuilder = new StringBuilder();
                        newFileBuilder.append(accNo).append("_").append(localDate).append("_").append((String)map.get("FlowNumber")).append("_").append((String)map.get("Amount")).append("_").append(String.format("%04d", recount)).append(".pdf");
                        countMap.put(flowNumber, recount);
                        newFileName = newFileBuilder.toString();
                    } else {
                        countMap.put(flowNumber, 0);
                    }
                    detail = new DownloadListDetail();
                    detail.setFileLink(filename);
                    detail.setFileName(newFileName);
                    detailList.add(detail);
                    try {
                        Thread.sleep(5000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        logger.error("\u5149\u5927\u94f6\u884c\u56de\u5355\u67e5\u8be2\u4f11\u7720\u5f02\u5e38", (Throwable)e);
                    }
                }
                ++searchCount;
            } while (hasNextPage);
        } else {
            BankReceiptFileAppointmentImpl bankReceiptFileAppointment = new BankReceiptFileAppointmentImpl();
            String cifNo = config.getCifNo();
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)16);
            String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
            String seqNo = cifNo + transDateStr + Sequence.gen16Sequence();
            paramMap.put("seqNo", seqNo);
            BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).paramsMap((Map)paramMap).build();
            HashMap runningParams = Maps.newHashMapWithExpectedSize((int)16);
            runningParams.put("transDateStr", transDateStr);
            EBContext.getContext().setRunningParams((Map)runningParams);
            BankReceiptResponseEB receiptResponseEB = (BankReceiptResponseEB)bankReceiptFileAppointment.doBiz((BankRequest)bankReceiptRequest);
            String response = (String)receiptResponseEB.getData();
            DownloadListDetail detail = new DownloadListDetail();
            detail.setFileLink(response);
            detail.setFileName(seqNo + "_ofd.zip");
            detailList.add(detail);
        }
        return BankReceiptHandleResponseEB.success(detailList);
    }

    public boolean isBreak() {
        return true;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CEB_DC_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u5149\u5927\u94f6\u884c\u56de\u5355\u6587\u4ef6\u5217\u8868\u3002", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-ceb-dc", (Object[])new Object[0]);
    }
}

