/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ceb.dc.service.receipt.api;

import java.time.LocalDate;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.receipt.banks.ceb.dc.service.receipt.util.pdf.RequsetPacker;
import kd.ebg.receipt.banks.ceb.dc.service.receipt.util.pdf.ResponseParser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;

public class BankReceiptNameQueryImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptNameQueryImpl.class);

    public String pack(BankReceiptRequest request) {
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String bankLoginId = EBContext.getContext().getBankLoginID();
        Map paramMap = request.getParamsMap();
        String billNumber = (String)paramMap.get("billNumber");
        String receiptRequest = RequsetPacker.receiptPack(billNumber, accNo, transDate, bankLoginId);
        return receiptRequest;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        String filename = ResponseParser.receiptParser(responseStr);
        return BankReceiptResponseEB.success((Object)filename);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CEB_DC_RECEIPT_INFO_REQUEST";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5149\u5927\u94f6\u884c\u94f6\u884c\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d\u8bf7\u6c42\u3002", (String)"BankReceiptNameQueryImpl_0", (String)"ebg-receipt-banks-ceb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        String cipher = RequestContextUtils.getRunningParam((String)"cipher");
        factory.setUri("/ent/b2e005023.do?userPassword=" + cipher);
        factory.setHttpHeader("Content-Type", "application/xml");
    }
}

