/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ceb.dc.service.receipt.util.ofd;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.ceb.dc.service.CebDCCommConfig;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import org.jdom2.Document;
import org.jdom2.Element;

public class OFDPacker {
    public static Element buildRoot() {
        Element element = JDomUtils.createRoot((String)"Transaction");
        return element;
    }

    public static String requestToXml(Element systemHead, Element transHead, Element transContent) {
        Element element = OFDPacker.buildRoot();
        JDomUtils.addChild((Element)element, (Element)systemHead);
        JDomUtils.addChild((Element)element, (Element)transHead);
        JDomUtils.addChild((Element)element, (Element)transContent);
        String request = JDomUtils.doc2StrGBK((Document)new Document(element));
        return request;
    }

    public static Element buildB2e004034TransContent(String clientPatchId, String clientBchID, String clientPchID) {
        Element element = JDomUtils.createRoot((String)"TransContent");
        Element reqData = JDomUtils.addChild((Element)element, (String)"ReqData");
        JDomUtils.addChild((Element)reqData, (String)"ClientPatchID", (String)clientPatchId);
        JDomUtils.addChild((Element)reqData, (String)"ClientBchID", (String)clientBchID);
        JDomUtils.addChild((Element)reqData, (String)"ClientPchID", (String)clientPchID);
        return element;
    }

    public static Element buildB2e004032TransContent(String clientPatchId, String accNo, LocalDate transDate) {
        Element element = JDomUtils.createRoot((String)"TransContent");
        Element reqData = JDomUtils.addChild((Element)element, (String)"ReqData");
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        JDomUtils.addChild((Element)reqData, (String)"ClientPatchID", (String)clientPatchId);
        JDomUtils.addChild((Element)reqData, (String)"ActNo", (String)accNo);
        JDomUtils.addChild((Element)reqData, (String)"BeginDate", (String)transDateStr);
        JDomUtils.addChild((Element)reqData, (String)"EndDate", (String)transDateStr);
        JDomUtils.addChild((Element)reqData, (String)"FileType", (String)"2");
        JDomUtils.addChild((Element)reqData, (String)"SHFOBZ", (String)"1");
        JDomUtils.addChild((Element)reqData, (String)"ElecBillForm", (String)"2");
        return element;
    }

    public static Element buildB2e004036TransContent(String clientPatchId, String accNo, LocalDate transDate) {
        Element element = JDomUtils.createRoot((String)"TransContent");
        Element reqData = JDomUtils.addChild((Element)element, (String)"ReqData");
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        String period = transDateStr.substring(0, 6);
        JDomUtils.addChild((Element)reqData, (String)"ClientPatchID", (String)clientPatchId);
        JDomUtils.addChild((Element)reqData, (String)"ActNo", (String)accNo);
        JDomUtils.addChild((Element)reqData, (String)"Period", (String)period);
        JDomUtils.addChild((Element)reqData, (String)"SortType", (String)"0");
        JDomUtils.addChild((Element)reqData, (String)"ElecBillForm", (String)"1");
        return element;
    }

    public static Element buildB2e004037TransContent(String clientPatchId, String clientBchID, String clientPchID) {
        Element element = JDomUtils.createRoot((String)"TransContent");
        Element reqData = JDomUtils.addChild((Element)element, (String)"ReqData");
        JDomUtils.addChild((Element)reqData, (String)"ClientPatchID", (String)clientPatchId);
        JDomUtils.addChild((Element)reqData, (String)"ClientBchID", (String)clientBchID);
        JDomUtils.addChild((Element)reqData, (String)"ClientPchID", (String)clientPchID);
        return element;
    }

    public static Element buildHead(String transCode, String seqNo) {
        Element element = JDomUtils.createRoot((String)"TransHead");
        JDomUtils.addChild((Element)element, (String)"TransCode", (String)transCode);
        JDomUtils.addChild((Element)element, (String)"BatchID", (String)seqNo);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        JDomUtils.addChild((Element)element, (String)"JnlDate", (String)formatter.format(LocalDate.now()));
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("HHMMSS");
        JDomUtils.addChild((Element)element, (String)"JnlTime", (String)dateTimeFormatter.format(LocalDateTime.now()));
        return element;
    }

    public static Element buildSystemHead() {
        String bankLoginId = EBContext.getContext().getBankLoginID();
        CebDCCommConfig config = (CebDCCommConfig)EBConfigBuilder.getInstance().buildConfig(CebDCCommConfig.class, bankLoginId);
        Element systemHead = JDomUtils.createRoot((String)"SystemHead");
        JDomUtils.addChild((Element)systemHead, (String)"Language", (String)"zh_CN");
        JDomUtils.addChild((Element)systemHead, (String)"Encodeing", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"Version", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"ServiceName", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"CifNo", (String)config.getCifNo());
        JDomUtils.addChild((Element)systemHead, (String)"UserID", (String)config.getUserID());
        JDomUtils.addChild((Element)systemHead, (String)"SyMacFlag", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"MAC", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"SyPinFlag", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"PinSeed", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"LicenseId", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"Flag", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"Note", (String)"");
        return systemHead;
    }
}

