/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ceb.dc.service.reconciliation;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.ceb.dc.service.receipt.util.ofd.ReceiptQueryInfo;
import kd.ebg.receipt.banks.ceb.dc.service.reconciliation.api.BankOFDReconciliationFileDownloadImpl;
import kd.ebg.receipt.banks.ceb.dc.service.reconciliation.api.BankReconciliationFileAppointmentQueryImpl;
import kd.ebg.receipt.business.receipt.atom.reconciliation.AbstractBankReconciliationDownloadHandleImpl;
import kd.ebg.receipt.business.receipt.atom.reconciliation.IBankReconciliationHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.reconciliation.BankReconciliationRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.reconciliation.BankReconciliationResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.reconciliation.BankReconciliationHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.reconciliation.BankReconciliationHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.model.reconciliation.ReconciliationDetail;
import kd.ebg.receipt.common.model.reconciliation.ReconciliationInfo;
import kd.ebg.receipt.common.utils.FileCommonUtils;

public class BankReconciliationDownloadImpl
extends AbstractBankReconciliationDownloadHandleImpl
implements IBankReconciliationHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReconciliationDownloadImpl.class);

    public boolean match(BankReconciliationHandleRequest request) {
        if (request == null) {
            return false;
        }
        if (!RequestContextUtils.isSupportReconciliation((String)EBContext.getContext().getBankLoginID())) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u8be5\u94f6\u884c\u4e0d\u652f\u6301\u5bf9\u8d26\u5355\u3002", (String)"BankReconciliationDownloadImpl_0", (String)"ebg-receipt-banks-ceb-dc", (Object[])new Object[0]));
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReconciliationHandleResponseEB doBiz(BankReconciliationHandleRequest request) {
        String bankLoginId = request.getBankLoginId();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        String accNo = request.getAccNo();
        String bankVersionId = request.getBankVersionId();
        String bakFilePath = FileStorageUtil.getReconciliationFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        List downloadListDetails = request.getDetails();
        ArrayList<ReconciliationDetail> result = new ArrayList<ReconciliationDetail>(16);
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLoginId);
        ReconciliationInfo task = request.getTask();
        String bankLogin = EBContext.getContext().getBankLoginID();
        String bakPathParentPath = FileStorageUtil.getReconciliationFileBakPath((String)bankLogin) + File.separator + transDateStr;
        for (int i = 0; i < downloadListDetails.size(); ++i) {
            JSONObject jsonObject;
            ReconciliationDetail downloadListDetail = (ReconciliationDetail)downloadListDetails.get(i);
            String fileLink = downloadListDetail.getFileLink();
            try {
                jsonObject = JSONObject.parseObject((String)fileLink);
            }
            catch (Exception e) {
                throw new ReceiptException((Throwable)e);
            }
            BankReconciliationFileAppointmentQueryImpl bankReconciliationFileAppointment = new BankReconciliationFileAppointmentQueryImpl();
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)16);
            paramMap.put("ClientBchID", jsonObject.get((Object)"ClientBchID"));
            paramMap.put("ClientPchID", jsonObject.get((Object)"ClientPchID"));
            BankReconciliationRequest bankReconciliationRequest = BankReconciliationRequest.builder().accNo(accNo).transDate(transDate).paramsMap((Map)paramMap).build();
            BankReconciliationResponseEB reconciliationResponseEB = (BankReconciliationResponseEB)bankReconciliationFileAppointment.doBiz((BankRequest)bankReconciliationRequest);
            List receiptQueryInfoList = (List)reconciliationResponseEB.getData();
            for (ReceiptQueryInfo receiptQueryInfo : receiptQueryInfoList) {
                String fileName = receiptQueryInfo.getFileName();
                String filePath = receiptQueryInfo.getFilePath();
                HashMap runningParams = Maps.newHashMapWithExpectedSize((int)16);
                runningParams.put("fileName", fileName);
                runningParams.put("filePath", filePath);
                EBContext.getContext().setRunningParams((Map)runningParams);
                BankOFDReconciliationFileDownloadImpl bankOFDReconciliationFileDownload = new BankOFDReconciliationFileDownloadImpl();
                BankReconciliationRequest bankRequest = BankReconciliationRequest.builder().accNo(accNo).transDate(transDate).build();
                bankOFDReconciliationFileDownload.doBiz((BankRequest)bankRequest);
                this.download(fileName, transDate, accNo, bankLoginId, bankFtpProperties, bakPathParentPath);
                List details = FileCommonUtils.getDetailList((ReconciliationInfo)task, (String)fileName);
                for (ReconciliationDetail detail : details) {
                    String ofdName = detail.getFileName();
                    StringBuilder newReceiptName = new StringBuilder();
                    newReceiptName.append(accNo).append("_");
                    newReceiptName.append(transDateStr).append("_");
                    newReceiptName.append(ofdName);
                    StringBuilder receiptPath = new StringBuilder();
                    receiptPath.append(bakFilePath).append(File.separator).append(ofdName);
                    File receiptFile = FileCommonUtils.getFileByPath((String)receiptPath.toString());
                    boolean isRename = FileCommonUtils.moveFile((File)receiptFile, (String)bakFilePath, (String)newReceiptName.toString());
                    if (!isRename) continue;
                    detail.setFileName(newReceiptName.toString());
                    detail.setFileLink(fileLink);
                    result.add(detail);
                }
            }
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u5bf9\u8d26\u5355\u6587\u4ef6\u4e3a\u7a7a\u3002", (String)"BankReconciliationDownloadImpl_1", (String)"ebg-receipt-banks-ceb-dc", (Object[])new Object[0]));
        }
        return BankReconciliationHandleResponseEB.success(result);
    }

    public void download(String zipName, LocalDate transDate, String accNo, String bankLoginId, BankFtpProperties bankFtpProperties, String bakPathParentPath) {
        ChannelSftp sftp = null;
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
            String sftp_path = bankFtpProperties.getFtpPath();
            String string = sftp_path = EBGStringUtils.isEmpty((String)sftp_path) ? "/" + LocalDate.now() : sftp_path + "/" + LocalDate.now();
            if (SFTPUtils.getInstance().isAbort(sftp)) {
                sftp = SFTPUtils.getInstance().getSftp(bankLoginId);
            }
            boolean flag = false;
            if (SFTPUtils.getInstance().isDirExist(sftp_path, sftp)) {
                flag = SFTPUtils.getInstance().downloadSingleFile(sftp_path, zipName, bakPathParentPath, sftp);
            }
            if (!flag) {
                sftp_path = bankFtpProperties.getFtpPath();
                sftp_path = EBGStringUtils.isEmpty((String)sftp_path) ? "/" + transDate : sftp_path + "/" + transDate;
                flag = SFTPUtils.getInstance().downloadSingleFile(sftp_path, zipName, bakPathParentPath, sftp);
            }
            logger.info("CEB_DC-OFD\u538b\u7f29\u5305sftp\u4e0b\u8f7d-{}-{}-\u538b\u7f29\u5305\uff1a{}-\u4e0b\u8f7d\u662f\u5426\u6210\u529f\uff1a{}", new Object[]{accNo, transDate, zipName, flag});
            SFTPUtils.getInstance().close(sftp);
        } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
            String ftpPath = bankFtpProperties.getFrontProxyPath() + File.separator + transDate;
            List<String> tempFiles = this.getFileByName(zipName, accNo, transDate);
            logger.info("\u5149\u5927\u94f6\u884c\u901a\u8fc7\u4ee3\u7406\u83b7\u53d6\u5bf9\u8d26\u5355\u6587\u4ef6===== tempFiles {}", (Object)tempFiles.toString());
            if (tempFiles == null || tempFiles.size() == 0) {
                tempFiles = this.getFileByName(zipName, accNo, LocalDate.now());
                ftpPath = bankFtpProperties.getFrontProxyPath() + File.separator + LocalDate.now();
            }
            if (tempFiles != null && tempFiles.size() != 0) {
                BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
                boolean flag = bankReceiptApiUtil.downloadReceiptFileWithPath(ftpPath, zipName, bakPathParentPath);
                logger.info("CEB_DC-OFD\u538b\u7f29\u5305\u4ee3\u7406\u7a0b\u5e8f\u4e0b\u8f7d-{}-{}-\u538b\u7f29\u5305\uff1a{}-\u4e0b\u8f7d\u662f\u5426\u6210\u529f\uff1a{}", new Object[]{accNo, transDate, zipName, flag});
            }
        }
        File file = FileCommonUtils.getFileByPath((String)(bakPathParentPath + File.separator + zipName));
        if (!file.exists()) {
            StringBuilder errorMsg = new StringBuilder();
            errorMsg.append(ResManager.loadKDString((String)"\u538b\u7f29\u5305\uff1a", (String)"BankReconciliationDownloadImpl_2", (String)"ebg-receipt-banks-ceb-dc", (Object[])new Object[0])).append(zipName).append(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728", (String)"BankReconciliationDownloadImpl_3", (String)"ebg-receipt-banks-ceb-dc", (Object[])new Object[0]));
            throw new ReceiptException(errorMsg.toString());
        }
    }

    private List<String> getFileByName(String matchString, String accNo, LocalDate transDate) {
        BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
        return bankReceiptApiUtil.getFileByName(matchString);
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "CEB_DC_BankReconciliationDownload";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5149\u5927\u94f6\u884c\u5bf9\u8d26\u5355\u6587\u4ef6\u4e0b\u8f7d", (String)"BankReconciliationDownloadImpl_4", (String)"ebg-receipt-banks-ceb-dc", (Object[])new Object[0]);
    }
}

