/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ceb.dc.service.reconciliation;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.ceb.dc.service.CebDCCommConfig;
import kd.ebg.receipt.banks.ceb.dc.service.reconciliation.api.BankReconciliationFileAppointmentImpl;
import kd.ebg.receipt.business.receipt.atom.reconciliation.AbstractBankReconciliationFetchHandleImpl;
import kd.ebg.receipt.business.receipt.atom.reconciliation.IBankReconciliationHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.reconciliation.BankReconciliationRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.reconciliation.BankReconciliationResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.reconciliation.BankReconciliationHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.reconciliation.BankReconciliationHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.services.reconciliation.ReconciliationDownloadListDetailService;
import kd.ebg.receipt.common.model.reconciliation.ReconciliationDetail;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReconciliationFetchListImpl
extends AbstractBankReconciliationFetchHandleImpl
implements IBankReconciliationHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReconciliationFetchListImpl.class);
    public ReconciliationDownloadListDetailService reconciliationDownloadListDetailService;

    public void init(BankReconciliationHandleRequest request) {
        this.reconciliationDownloadListDetailService = (ReconciliationDownloadListDetailService)SpringContextUtil.getBean(ReconciliationDownloadListDetailService.class);
    }

    public boolean match(BankReconciliationHandleRequest request) {
        if (request == null) {
            return false;
        }
        if (!RequestContextUtils.isSupportReconciliation((String)EBContext.getContext().getBankLoginID())) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u8be5\u94f6\u884c\u4e0d\u652f\u6301\u5bf9\u8d26\u5355", (String)"BankReconciliationFetchListImpl_0", (String)"ebg-receipt-banks-ceb-dc", (Object[])new Object[0]));
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReconciliationHandleResponseEB doBiz(BankReconciliationHandleRequest request) {
        this.init(request);
        String bankLoginId = request.getBankLoginId();
        LocalDate transDate = request.getTransDate();
        String localDate = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String accNo = request.getAccNo();
        ArrayList<ReconciliationDetail> result = new ArrayList<ReconciliationDetail>(16);
        CebDCCommConfig config = (CebDCCommConfig)EBConfigBuilder.getInstance().buildConfig(CebDCCommConfig.class, bankLoginId);
        BankReconciliationFileAppointmentImpl bankReceiptFileAppointment = new BankReconciliationFileAppointmentImpl();
        String cifNo = config.getCifNo();
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)16);
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        String seqNo = cifNo + transDateStr + Sequence.gen16Sequence();
        paramMap.put("seqNo", seqNo);
        BankReconciliationRequest bankReceiptRequest = BankReconciliationRequest.builder().accNo(accNo).transDate(transDate).paramsMap((Map)paramMap).build();
        HashMap runningParams = Maps.newHashMapWithExpectedSize((int)16);
        runningParams.put("transDateStr", transDateStr);
        EBContext.getContext().setRunningParams((Map)runningParams);
        BankReconciliationResponseEB receiptResponseEB = (BankReconciliationResponseEB)bankReceiptFileAppointment.doBiz((BankRequest)bankReceiptRequest);
        String response = (String)receiptResponseEB.getData();
        ReconciliationDetail detail = new ReconciliationDetail();
        detail.setFileLink(response);
        detail.setFileName(seqNo + "_reconciliation_ofd.zip");
        result.add(detail);
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u5bf9\u8d26\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a", (String)"BankReconciliationFetchListImpl_1", (String)"ebg-receipt-banks-ceb-dc", (Object[])new Object[0]));
        }
        return BankReconciliationHandleResponseEB.success(result);
    }

    public boolean isBreak() {
        return true;
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "CEB_DC_BankReconciliationFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u5149\u5927\u94f6\u884c\u5bf9\u8d26\u5355\u6587\u4ef6\u5217\u8868\u3002", (String)"BankReconciliationFetchListImpl_2", (String)"ebg-receipt-banks-ceb-dc", (Object[])new Object[0]);
    }
}

