/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.tlyh.dc.service.receipt.api.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;

public class ResponseParser {
    public static boolean queryReceiptResponse(String responseStr, int page, int pageNum, Map<String, String> numMap) {
        if (EBGStringUtils.isEmpty((String)responseStr)) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u94f6\u884c\u54cd\u5e94\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"ResponseParser_0", (String)"ebg-receipt-banks-tlyh-dc", (Object[])new Object[0]));
        }
        JSONObject jsonObject = JSONObject.parseObject((String)responseStr);
        JSONObject head = jsonObject.getJSONObject("head");
        BankResponse rsp = new BankResponse();
        rsp.setResponseCode(head.getString("errorCode"));
        rsp.setResponseMessage(head.getString("errorMsg"));
        if (!"000000".equalsIgnoreCase(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672c\u6b21\u67e5\u8be2\u8fd4\u56de\u4e86\u975e\u6b63\u5e38\u7684\u8fd4\u56de\u7801\uff1a%1$s;\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%2$s\u3002", (String)"ResponseParser_3", (String)"ebg-receipt-banks-tlyh-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        JSONObject body = jsonObject.getJSONObject("body");
        JSONArray lbyAcctDtlArray = body.getJSONArray("rcptSmyArray");
        if (lbyAcctDtlArray.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u56de\u5355\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"ResponseParser_2", (String)"ebg-receipt-banks-tlyh-dc", (Object[])new Object[0]));
        }
        String se = "_";
        for (Object receiptObject : lbyAcctDtlArray) {
            JSONObject receiptJSON = (JSONObject)receiptObject;
            String rcptNo = receiptJSON.getString("rcptNo");
            String acctNo = receiptJSON.getString("acctNo");
            String oriTranDate = receiptJSON.getString("oriTranDate");
            String oriTranSeqNo = receiptJSON.getString("oriTranSeqNo");
            String oriTranAmt = receiptJSON.getString("oriTranAmt");
            oriTranAmt = new BigDecimal(oriTranAmt).setScale(2, 4).toString();
            String drCrFlag = receiptJSON.getString("drCrFlag");
            StringBuilder fileName = new StringBuilder();
            fileName.append(acctNo).append("_");
            fileName.append(oriTranDate).append("_");
            fileName.append(oriTranSeqNo).append("_");
            fileName.append(oriTranAmt).append("_");
            fileName.append(drCrFlag).append(".pdf");
            numMap.put(rcptNo, fileName.toString());
        }
        String totalRows = body.getString("totalRows");
        return pageNum * page >= Integer.parseInt(totalRows);
    }

    public static String queryReceiptResponse(String rspStr) {
        if (EBGStringUtils.isEmpty((String)rspStr)) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u94f6\u884c\u54cd\u5e94\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"ResponseParser_0", (String)"ebg-receipt-banks-tlyh-dc", (Object[])new Object[0]));
        }
        JSONObject jsonObject = JSONObject.parseObject((String)rspStr);
        JSONObject head = jsonObject.getJSONObject("head");
        BankResponse rsp = new BankResponse();
        rsp.setResponseCode(head.getString("errorCode"));
        rsp.setResponseMessage(head.getString("errorMsg"));
        if (!"000000".equalsIgnoreCase(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672c\u6b21\u67e5\u8be2\u8fd4\u56de\u4e86\u975e\u6b63\u5e38\u7684\u8fd4\u56de\u7801\uff1a%1$s;\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%2$s\u3002", (String)"ResponseParser_3", (String)"ebg-receipt-banks-tlyh-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        JSONObject body = jsonObject.getJSONObject("body");
        return body.getString("filePath");
    }
}

