/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.tlyh.dc.service.receipt.fetch;

import com.google.common.collect.Maps;
import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.receipt.banks.tlyh.dc.service.receipt.api.BankReceiptCreateImpl;
import kd.ebg.receipt.banks.tlyh.dc.service.receipt.api.helper.RequestPacker;
import kd.ebg.receipt.banks.tlyh.dc.service.receipt.api.helper.ResponseParser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.core.utils.GZFileUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.framework.utils.CurrencyUtils;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.DownloadUtils;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.PropertiesConstantsUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class ReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public String getDeveloper() {
        return "KINGDEE";
    }

    public String getBizCode() {
        return "RECEIPT_FETCHLIST";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        boolean flag;
        this.init(request);
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"TLYH_DC", (String)accNo, (String)transDateStr);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>();
        int page = 1;
        int pageNum = 50;
        String clientNo = RequestContextUtils.getBankParameterValue((String)"clientNo");
        BankAcnt mainAcnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(request.getAccNo(), EBContext.getContext().getCustomID());
        String currency = mainAcnt.getCurrency();
        String bankCurrency = CurrencyUtils.convert2Bank((String)currency);
        boolean isUrlDownload = PropertiesConstantsUtils.checkValueIsYes((String)RequestContextUtils.getBankParameterValue((String)"is_url_download"));
        HashMap map = Maps.newHashMapWithExpectedSize((int)1);
        do {
            HashMap numMap = Maps.newHashMapWithExpectedSize((int)1);
            int currentNum = 1 + (page - 1) * pageNum;
            String queryReceiptRequest = RequestPacker.queryReceiptRequest(accNo, transDateStr, clientNo, "0", pageNum, currentNum, numMap, bankCurrency, isUrlDownload);
            BankReceiptCreateImpl bankReceiptCreate = new BankReceiptCreateImpl();
            BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().requestStr(queryReceiptRequest).build();
            BankReceiptResponseEB receiptResponseEB = bankReceiptCreate.doBiz(bankReceiptRequest);
            String queryReceiptResponse = (String)receiptResponseEB.getData();
            flag = ResponseParser.queryReceiptResponse(queryReceiptResponse, page, pageNum, numMap);
            logger.info("\u56de\u5355\u7f16\u53f7\u7684\u6570\u91cf\uff1a" + numMap.size());
            queryReceiptRequest = RequestPacker.queryReceiptRequest(accNo, transDateStr, clientNo, "1", pageNum, currentNum, numMap, bankCurrency, isUrlDownload);
            bankReceiptRequest.setRequestStr(queryReceiptRequest);
            receiptResponseEB = bankReceiptCreate.doBiz(bankReceiptRequest);
            queryReceiptResponse = (String)receiptResponseEB.getData();
            String filePath = ResponseParser.queryReceiptResponse(queryReceiptResponse);
            map.put(filePath, numMap);
            ++page;
        } while (!flag);
        ChannelSftp sftp = null;
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, request.getBankLoginId());
        try {
            if (!isUrlDownload && bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                sftp = SFTPUtils.getInstance().getSftp();
            }
            for (Map.Entry mapEntry : map.entrySet()) {
                String filePath = (String)mapEntry.getKey();
                Map receiptMap = (Map)mapEntry.getValue();
                this.downloadFile(request, filePath, bakFilePath, isUrlDownload, bankFtpProperties, sftp);
                for (Map.Entry receipt : receiptMap.entrySet()) {
                    String receiptNo = (String)receipt.getKey();
                    String newReceiptFileName = (String)receipt.getValue();
                    String receiptFileName = receiptNo + ".pdf";
                    File receiptFile = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + receiptFileName));
                    if (!receiptFile.exists()) {
                        logger.info("\u6587\u4ef6\u8def\u5f84\uff1a{}-\u538b\u7f29\u5305\u4e2d\u672a\u5305\u542b\u6587\u4ef6\u540d\uff1a{} \u7684\u56de\u5355\u6587\u4ef6", new Object[]{filePath, receiptFileName});
                        continue;
                    }
                    boolean isMove = FileCommonUtils.moveFile((File)receiptFile, (String)bakFilePath, (String)newReceiptFileName);
                    if (!isMove) continue;
                    DownloadListDetail downloadListDetail = new DownloadListDetail();
                    downloadListDetail.setFileLink(filePath);
                    downloadListDetail.setFileName(newReceiptFileName);
                    result.add(downloadListDetail);
                    FileCommonUtils.deleteFile((File)FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + receiptFileName)));
                }
            }
            if (isUrlDownload) return BankReceiptHandleResponseEB.success(result);
        }
        catch (Throwable throwable) {
            if (isUrlDownload) throw throwable;
            SFTPUtils.getInstance().close(sftp);
            throw throwable;
        }
        SFTPUtils.getInstance().close(sftp);
        return BankReceiptHandleResponseEB.success(result);
    }

    private List<DownloadListDetail> downloadFile(BankReceiptHandleRequest request, String filePath, String bakFilePath, boolean isUrlDownload, BankFtpProperties bankFtpProperties, ChannelSftp sftp) {
        ArrayList<DownloadListDetail> detailList = new ArrayList<DownloadListDetail>();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String zipFileName = String.format("%s_%s_%s.zip", request.getAccNo(), LocalDateUtil.formatDate((LocalDate)request.getTransDate()), Sequence.gen18Sequence());
        if (isUrlDownload) {
            DownloadUtils.download((String)filePath, (String)zipFileName, (String)bakFilePath);
        } else {
            String ftpPath;
            BankReceiptApiUtil bankReceiptApiUtil;
            boolean flag;
            zipFileName = filePath.substring(filePath.lastIndexOf("/") + 1);
            String lastPath = filePath.substring(0, filePath.lastIndexOf("/"));
            if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                boolean flag2;
                String sftp_path = bankFtpProperties.getFtpPath();
                String string = sftp_path = EBGStringUtils.isNotEmpty((String)sftp_path) ? sftp_path : "/";
                if (sftp != null && EBGStringUtils.isNotEmpty((String)sftp_path) && !(flag2 = SFTPUtils.getInstance().downloadSingleFile(sftp_path + lastPath, zipFileName, bakFilePath, sftp))) {
                    throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6[%s]\u4e0b\u8f7d\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5SFTP\u76ee\u5f55\u662f\u5426\u5b58\u5728\u8be5\u6587\u4ef6\u3002", (String)"ReceiptFetchListImpl_0", (String)"ebg-receipt-banks-tlyh-dc", (Object[])new Object[0]), zipFileName));
                }
            } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login") && !(flag = (bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate)).downloadReceiptFileWithPath((ftpPath = bankFtpProperties.getFrontProxyPath()) + lastPath, zipFileName, bakFilePath))) {
                throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u603b\u5305\u6587\u4ef6[%s]\u4e0b\u8f7d\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u524d\u7f6e\u673a\u76ee\u5f55\u662f\u5426\u5b58\u5728\u8be5\u6587\u4ef6\u3002", (String)"ReceiptFetchListImpl_1", (String)"ebg-receipt-banks-tlyh-dc", (Object[])new Object[0]), zipFileName));
            }
        }
        this.listReceiptFile(bakFilePath, zipFileName);
        return detailList;
    }

    public void listReceiptFile(String bakFilePath, String zipFileName) {
        String batchUnZipPath = bakFilePath + File.separator + "temp";
        if (GZFileUtils.unZipFiles((String)(bakFilePath + File.separator + zipFileName), (String)batchUnZipPath)) {
            File[] files;
            File file = FileCommonUtils.getFileByPath((String)batchUnZipPath);
            for (File receiptFile : files = file.listFiles()) {
                String fileName = receiptFile.getName();
                if (!fileName.contains(".pdf")) continue;
                FileCommonUtils.moveFile((File)receiptFile, (String)bakFilePath, (String)fileName);
            }
            File zipFile = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + zipFileName));
            if (zipFile.exists()) {
                boolean isDelete = zipFile.delete();
                logger.info("\u5220\u9664\u56de\u5355\u538b\u7f29\u5305:{} {}-\u89e3\u538b\u5230\u7684\u6587\u4ef6\u4e2a\u6570\uff1a{}", new Object[]{zipFileName, isDelete, files.length});
            }
            RequestContextUtils.setZipName((String)zipFileName);
        }
    }
}

