/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.citicb.dc.service.receipt;

import com.google.common.collect.Maps;
import java.io.File;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.citicb.dc.service.receipt.CITICBDCCommConfig;
import kd.ebg.receipt.banks.citicb.dc.service.receipt.api.BankReceiptDownRequestImpl;
import kd.ebg.receipt.banks.citicb.dc.service.receipt.util.ReceiptDetailUtil;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.core.utils.GZFileUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.bank.BankLoginProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoJsonService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import org.jdom2.Document;
import org.jdom2.Element;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public EBCReceiptInfoJsonService receiptInfoJsonService;
    private static final String TRANSCODE = "DLEDCDTD";
    private static final String SUCCESS = "AAAAAAA";

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.receiptInfoJsonService = (EBCReceiptInfoJsonService)SpringContextUtil.getBean(EBCReceiptInfoJsonService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String bankLogin = request.getBankLoginId();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"CITIC_DC", (String)accNo, (String)transDateStr);
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
        BankLoginProperties loginProperties = (BankLoginProperties)EBConfigBuilder.getInstance().buildConfig(BankLoginProperties.class, bankLogin);
        CITICBDCCommConfig config = (CITICBDCCommConfig)EBConfigBuilder.getInstance().buildConfig(CITICBDCCommConfig.class, bankLogin);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        boolean isToday = LocalDate.now().equals(transDate);
        for (int i = 0; i < downloadListDetails.size(); ++i) {
            DownloadListDetail detail = (DownloadListDetail)downloadListDetails.get(i);
            if (detail.getUploadFlag().intValue() == UploadStatusEnum.UPLOAD_SUCCESS.getId() && !isToday) {
                result.add(detail);
                continue;
            }
            boolean flag = this.download(detail, bakFilePath, loginProperties, bankFtpProperties, config);
            if (!flag) continue;
            if (isToday) {
                detail.setUploadFlag(Integer.valueOf(UploadStatusEnum.UN_UPLOAD.getId()));
                this.downloadListDetailService.update(detail);
            }
            result.add(detail);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public boolean download(DownloadListDetail detail, String destFolder, BankLoginProperties loginProperties, BankFtpProperties bankFtpProperties, CITICBDCCommConfig config) {
        boolean result = false;
        String fileName = detail.getFileLink();
        String newFileName = detail.getFileName();
        if (fileName != null && fileName.length() > 0) {
            String host = loginProperties.getIp();
            int port = loginProperties.getPort();
            String requestURL = "http://" + host + ":" + port;
            String receiptNo = ReceiptDetailUtil.getReciptNo(detail.getFileLink());
            String receiptType = ReceiptDetailUtil.getBusiType(detail.getFileLink());
            String accNo = ReceiptDetailUtil.getAccNo(detail.getFileLink());
            LocalDate transDate = detail.getTransDate();
            String request = this.getDownLoadRequest(accNo, receiptNo, receiptType, transDate, config);
            BankReceiptDownRequestImpl iBankReceipt = new BankReceiptDownRequestImpl();
            BankReceiptRequest receiptRequest = BankReceiptRequest.builder().requestStr(request).build();
            String response = (String)((BankReceiptResponseEB)iBankReceipt.doBiz((BankRequest)receiptRequest)).getData();
            Map<String, String> map = this.parse(response);
            if (map.containsKey("fileName") && map.containsKey("fileContent")) {
                String zipName = map.get("fileName");
                String unZipDir = destFolder + File.separator + zipName.replace(".zip", "");
                String filePath = destFolder + File.separator + zipName;
                String fileContent = map.get("fileContent");
                if (fileContent.length() > 0) {
                    if (!FileCommonUtils.base64ToFile((String)fileContent, (String)filePath)) {
                        throw new ReceiptException(ResManager.loadKDString((String)"Base64\u89e3\u7801\u53d1\u751f\u9519\u8bef\uff0c\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25\u3002", (String)"BankReceiptDownloadImpl_0", (String)"ebg-receipt-banks-citicb-dc", (Object[])new Object[0]));
                    }
                    File sourceFile = FileCommonUtils.getFileByPath((String)filePath);
                    if (!GZFileUtils.unZipFiles((String)filePath, (String)unZipDir)) {
                        throw new ReceiptException(ResManager.loadKDString((String)"ZIP\u6587\u4ef6\u89e3\u538b\u7f29\u5931\u8d25\u3002", (String)"BankReceiptDownloadImpl_1", (String)"ebg-receipt-banks-citicb-dc", (Object[])new Object[0]));
                    }
                    File unZipFile = FileCommonUtils.getFileByPath((String)unZipDir);
                    if (unZipFile.isDirectory()) {
                        for (File file : unZipFile.listFiles()) {
                            if (Objects.equals(config.getReceiptFileType(), "OFD") && file.getName().toLowerCase(Locale.ENGLISH).endsWith(".ofd")) {
                                FileCommonUtils.moveFile((File)file, (String)destFolder, (String)newFileName);
                            }
                            if (!Objects.equals(config.getReceiptFileType(), "PDF") || !file.getName().toLowerCase(Locale.ENGLISH).endsWith(".pdf")) continue;
                            FileCommonUtils.moveFile((File)file, (String)destFolder, (String)newFileName);
                        }
                    }
                    if (!sourceFile.delete()) {
                        logger.warn("\u5220\u9664\u538b\u7f29\u6587\u4ef6\uff1a{}\u53d1\u751f\u5f02\u5e38\u3002", new Object[]{sourceFile.getAbsolutePath()});
                    } else {
                        logger.info("\u5220\u9664\u538b\u7f29\u6587\u4ef6\uff1a{}\u6210\u529f\u3002", (Object)sourceFile.getAbsolutePath());
                    }
                    boolean isDelete = unZipFile.delete();
                    logger.info("\u5220\u9664\u6587\u4ef6\uff1a{}-{}", new Object[]{unZipFile.getName(), isDelete});
                    return true;
                }
                throw new ReceiptException(ResManager.loadKDString((String)"\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a", (String)"BankReceiptDownloadImpl_2", (String)"ebg-receipt-banks-citicb-dc", (Object[])new Object[0]));
            }
        }
        return result;
    }

    private String getDownLoadRequest(String accNo, String receiptNo, String receiptType, LocalDate transDate, CITICBDCCommConfig config) {
        String userId = config.getReceipFitchList_userId();
        String clientId = config.getReceipFitchList_clientId();
        Element root = JDomExtUtils.createRoot((String)"stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)TRANSCODE);
        JDomUtils.addChild((Element)root, (String)"userName", (String)userId);
        JDomUtils.addChild((Element)root, (String)"bankId", (String)clientId);
        String now = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String tDate = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JDomUtils.addChild((Element)root, (String)"isCurrDay", (String)(now.equals(tDate) ? "1" : "2"));
        JDomUtils.addChild((Element)root, (String)"accNo", (String)accNo);
        if (Objects.equals(config.getReceiptFileType(), "OFD")) {
            JDomUtils.addChild((Element)root, (String)"fileType", (String)"2");
        } else {
            JDomUtils.addChild((Element)root, (String)"fileType", (String)"1");
        }
        Element list = JDomUtils.addChild((Element)root, (String)"list");
        list.setAttribute("name", "userDataList");
        Element row = JDomUtils.addChild((Element)list, (String)"row");
        JDomUtils.addChild((Element)row, (String)"brSeqNo", (String)receiptNo);
        JDomUtils.addChild((Element)row, (String)"billType", (String)receiptType);
        return JDomExtUtils.doc2StrGBK((Document)new Document(root));
    }

    private Map<String, String> parse(String response) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)8);
        Element root = JDomExtUtils.str2DocGBK((String)response).getRootElement();
        String status = JDomExtUtils.getChildText((Element)root, (String)"status");
        String statusText = JDomExtUtils.getChildText((Element)root, (String)"statusText");
        if (!SUCCESS.equalsIgnoreCase(status)) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u8c03\u7528DLEDCDTD\u63a5\u53e3\u83b7\u53d6\u5230\u94f6\u884c\u8fd4\u56de\u7684\u9519\u8bef\u62a5\u6587\uff0c\u94f6\u884c\u8fd4\u56de\u7801[%1$s]\uff1a%2$s\u3002", (String)"BankReceiptDownloadImpl_5", (String)"ebg-receipt-banks-citicb-dc", (Object[])new Object[0]), status, statusText));
        }
        Element list = JDomExtUtils.getChildElement((Element)root, (String)"list");
        Element row = JDomExtUtils.getChildElement((Element)list, (String)"row");
        String pdfName = JDomExtUtils.getChildElement((Element)row, (String)"pdfName").getTextTrim();
        String fileName = JDomExtUtils.getChildElement((Element)root, (String)"fileName").getTextTrim();
        String fileContent = JDomExtUtils.getChildElement((Element)root, (String)"fileConTent").getTextTrim();
        String size = JDomExtUtils.getChildElement((Element)root, (String)"size").getTextTrim();
        result.put("pdfName", pdfName);
        result.put("fileName", fileName);
        result.put("fileContent", fileContent);
        result.put("size", size);
        return result;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "ZSB_DC_BankReceiptDownload";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6d59\u5546\u94f6\u884c\u76f4\u8fde\u7248\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d", (String)"BankReceiptDownloadImpl_4", (String)"ebg-receipt-banks-citicb-dc", (Object[])new Object[0]);
    }
}

