/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.citicb.dc.service.reconciliation;

import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.receipt.banks.citicb.dc.service.receipt.CITICBDCCommConfig;
import kd.ebg.receipt.banks.citicb.dc.service.reconciliation.api.BankReconciliationDownRequestImpl;
import kd.ebg.receipt.banks.citicb.dc.service.reconciliation.api.BankReconciliationQueryImpl;
import kd.ebg.receipt.business.receipt.atom.reconciliation.AbstractBankReconciliationFetchHandleImpl;
import kd.ebg.receipt.business.receipt.atom.reconciliation.IBankReconciliationHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.reconciliation.BankReconciliationHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.reconciliation.BankReconciliationHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.core.utils.GZFileUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.reconciliation.ReconciliationDownloadListDetailService;
import kd.ebg.receipt.common.model.reconciliation.ReconciliationDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReconciliationFetchListImpl
extends AbstractBankReconciliationFetchHandleImpl
implements IBankReconciliationHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReconciliationFetchListImpl.class);
    public ReconciliationDownloadListDetailService reconciliationDownloadListDetailService;

    public void init(BankReconciliationHandleRequest request) {
        this.reconciliationDownloadListDetailService = (ReconciliationDownloadListDetailService)SpringContextUtil.getBean(ReconciliationDownloadListDetailService.class);
    }

    public boolean match(BankReconciliationHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReconciliationHandleResponseEB doBiz(BankReconciliationHandleRequest bankReceiptHandleRequest) {
        this.init(bankReceiptHandleRequest);
        ArrayList<ReconciliationDetail> result = new ArrayList<ReconciliationDetail>(16);
        String accNo = bankReceiptHandleRequest.getAccNo();
        LocalDate transDate = bankReceiptHandleRequest.getTransDate();
        String bankLogin = bankReceiptHandleRequest.getBankLoginId();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        CITICBDCCommConfig config = (CITICBDCCommConfig)EBConfigBuilder.getInstance().buildConfig(CITICBDCCommConfig.class, bankLogin);
        BankReconciliationQueryImpl bankReconciliationQuery = new BankReconciliationQueryImpl();
        List<String> billNos = bankReconciliationQuery.queryReconciliation(config, accNo, bankReceiptHandleRequest.getTransDate());
        String bakFilePath = FileStorageUtil.getReconciliationFileBakPathByAccNoAndDate((String)"CITIC_DC", (String)accNo, (String)transDateStr);
        for (String billNo : billNos) {
            BankReceiptRequest request = BankReceiptRequest.builder().accNo(accNo).transDate(bankReceiptHandleRequest.getTransDate()).requestStr(billNo).build();
            BankReconciliationDownRequestImpl bankReconciliationDownRequest = new BankReconciliationDownRequestImpl();
            BankReceiptResponseEB receiptResponseEB = bankReconciliationDownRequest.doBiz(request);
            String fileContent = (String)receiptResponseEB.getData();
            String zipName = billNo + "_" + Sequence.gen16NumSequence() + ".zip";
            String unZipDir = bakFilePath + File.separator + zipName.replace(".zip", "");
            String filePath = bakFilePath + File.separator + zipName;
            if (!FileCommonUtils.base64ToFile((String)fileContent, (String)filePath)) {
                throw new ReceiptException(ResManager.loadKDString((String)"Base64\u89e3\u7801\u53d1\u751f\u9519\u8bef\uff0c\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25\u3002", (String)"BankReconciliationFetchListImpl_0", (String)"ebg-receipt-banks-citicb-dc", (Object[])new Object[0]));
            }
            File sourceFile = FileCommonUtils.getFileByPath((String)filePath);
            if (!GZFileUtils.unZipFiles((String)filePath, (String)unZipDir)) {
                throw new ReceiptException(ResManager.loadKDString((String)"ZIP\u6587\u4ef6\u89e3\u538b\u7f29\u5931\u8d25\u3002", (String)"BankReconciliationFetchListImpl_1", (String)"ebg-receipt-banks-citicb-dc", (Object[])new Object[0]));
            }
            File unZipFile = FileCommonUtils.getFileByPath((String)unZipDir);
            if (unZipFile.isDirectory()) {
                for (File file : unZipFile.listFiles()) {
                    FileCommonUtils.moveFile((File)file, (String)bakFilePath, (String)file.getName());
                    ReconciliationDetail downloadListDetail = new ReconciliationDetail();
                    downloadListDetail.setFileName(file.getName());
                    downloadListDetail.setFileLink(billNo);
                    result.add(downloadListDetail);
                }
            }
            if (!sourceFile.delete()) {
                logger.warn("\u5220\u9664\u538b\u7f29\u6587\u4ef6\uff1a{}\u53d1\u751f\u5f02\u5e38\u3002", new Object[]{sourceFile.getAbsolutePath()});
            } else {
                logger.info("\u5220\u9664\u538b\u7f29\u6587\u4ef6\uff1a{}\u6210\u529f\u3002", (Object)sourceFile.getAbsolutePath());
            }
            boolean isDelete = unZipFile.delete();
            logger.info("\u5220\u9664\u6587\u4ef6\uff1a{}-{}", new Object[]{unZipFile.getName(), isDelete});
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u5bf9\u8d26\u5355\u6570\u636e\u4e3a\u7a7a\uff0c\u5982\u679c\u8be5\u8d26\u53f7\u5f53\u524d\u6708\u4efd\u6709\u4ea4\u6613\uff0c\u8bf7\u8054\u7cfb\u94f6\u884c\u8dd1\u6279\u5904\u7406\u3002", (String)"BankReconciliationFetchListImpl_2", (String)"ebg-receipt-banks-citicb-dc", (Object[])new Object[0]));
        }
        return BankReconciliationHandleResponseEB.success(result);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CITICB_DC_BankReconciliationFetchList";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean isBreak() {
        return false;
    }
}

