/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.citicb.dc.service.reconciliation.api;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.citicb.dc.service.receipt.CITICBDCCommConfig;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class BankReconciliationQueryImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    public String pack(BankReceiptRequest request) {
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        return this.getRequestXml(accNo, transDate);
    }

    private String getRequestXml(String accNo, LocalDate transDate) {
        String userId = RequestContextUtils.getRunningParam((String)"userId");
        Element root = JDomExtUtils.createRoot((String)"stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)this.getBizCode());
        JDomUtils.addChild((Element)root, (String)"userName", (String)userId);
        JDomUtils.addChild((Element)root, (String)"accountNo", (String)accNo);
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        String nowTransDateStr = LocalDateUtil.formatDate((LocalDate)LocalDate.now());
        String nowMonth = nowTransDateStr.substring(0, 6) + "01";
        String startDate = transDateStr.substring(0, 6) + "01";
        String endDate = BankReconciliationQueryImpl.getLastDayOfMonth(transDateStr.substring(0, 6));
        if (Objects.equals(nowMonth, startDate)) {
            endDate = nowTransDateStr;
        }
        JDomUtils.addChild((Element)root, (String)"startDate", (String)startDate);
        JDomUtils.addChild((Element)root, (String)"endDate", (String)endDate);
        int startRecord = Integer.parseInt(this.getCurrentPage()) * Integer.parseInt("10");
        JDomUtils.addChild((Element)root, (String)"pageNumber", (String)"10");
        if (Objects.equals("0", this.getCurrentPage())) {
            JDomUtils.addChild((Element)root, (String)"startRecord", (String)"0");
        } else {
            JDomUtils.addChild((Element)root, (String)"startRecord", (String)Integer.toString(startRecord));
        }
        return JDomExtUtils.doc2StrGBK((Document)new Document(root));
    }

    public static String getLastDayOfMonth(String transDateStr) {
        int year = Integer.parseInt(transDateStr.substring(0, 4));
        int month = Integer.parseInt(transDateStr.substring(4));
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month);
        int lastDay = cal.getMinimum(5);
        cal.set(5, lastDay - 1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String lastDayOfMonth = sdf.format(cal.getTime());
        return lastDayOfMonth;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        return BankReceiptResponseEB.success(this.parseFileInfo(responseStr));
    }

    private List<String> parseFileInfo(String responseStr) {
        ArrayList<String> result = new ArrayList<String>(16);
        Element root = JDomExtUtils.str2DocGBK((String)responseStr).getRootElement();
        String status = JDomExtUtils.getChildText((Element)root, (String)"status");
        String statusText = JDomExtUtils.getChildText((Element)root, (String)"statusText");
        if ("AAAAAAA".equalsIgnoreCase(status)) {
            Element list = JDomExtUtils.getChildElement((Element)root, (String)"list");
            List elements = list.getChildren("row");
            for (Element e : elements) {
                String bresqNo = JDomExtUtils.getChildText((Element)e, (String)"billNo");
                if (!StringUtils.isNotEmpty((String)bresqNo)) continue;
                result.add(bresqNo);
            }
            if (result.isEmpty()) {
                this.setLastPage(true);
            }
        } else {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u8c03\u7528DLADBDQY\u63a5\u53e3\u83b7\u53d6\u5230\u94f6\u884c\u8fd4\u56de\u7684\u9519\u8bef\u62a5\u6587\uff0c\u94f6\u884c\u8fd4\u56de\u7801[%1$s]\uff1a%2$s\u3002", (String)"BankReconciliationQueryImpl_0", (String)"ebg-receipt-banks-citicb-dc", (Object[])new Object[0]), status, statusText));
        }
        return result;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "DLADBDQY";
    }

    public String getBizDesc() {
        return "";
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/xml");
    }

    public List<String> queryReconciliation(CITICBDCCommConfig config, String accNo, LocalDate transDate) {
        ArrayList<String> result = new ArrayList<String>(1);
        BankReceiptRequest request = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).build();
        RequestContextUtils.setRunningParam((String)"userId", (String)config.getReceipFitchList_userId());
        this.setCurrentPage("0");
        boolean lastPage = false;
        this.setLastPage(false);
        while (!lastPage) {
            BankReceiptResponseEB response = this.doBiz(request);
            List receiveItems = (List)response.getData();
            if (Objects.nonNull(response) && Objects.nonNull(receiveItems)) {
                result.addAll(receiveItems);
            }
            lastPage = this.isLastPage();
            this.setCurrentPage(Integer.parseInt(this.getCurrentPage()) + 1);
        }
        return result;
    }
}

