/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.hfb.dc.service.receipt;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.hfb.dc.service.receipt.HFBDcCommConfig;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.DownloadUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        if (downloadListDetails.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptDownloadImpl_0", (String)"ebg-receipt-banks-hfb-dc", (Object[])new Object[0]));
        }
        if (Objects.equals(HFBDcCommConfig.getInstance().getRECEIPT_PUSH_CHANNEL(), "MASTER")) {
            return BankReceiptHandleResponseEB.success((Object)downloadListDetails);
        }
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        String filePathPre = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"HFB_DC", (String)accNo, (String)transDateStr);
        for (DownloadListDetail downloadListDetail : downloadListDetails) {
            HashMap runningParams = Maps.newHashMapWithExpectedSize((int)16);
            String fileurl = downloadListDetail.getFileLink();
            String fileName = downloadListDetail.getFileName();
            runningParams.put("url", fileurl);
            runningParams.put("fileName", fileName);
            runningParams.put("savePath", filePathPre);
            EBContext.getContext().setRunningParams((Map)runningParams);
            try {
                DownloadUtils.download((String)fileurl, (String)fileName, (String)filePathPre);
                result.add(downloadListDetail);
            }
            catch (Exception exception) {
                logger.error("\u6052\u4e30\u94f6\u884c\u56de\u5355\u4e0b\u8f7d\u5931\u8d25..\uff0c\u5931\u8d25\u539f\u56e0" + exception.getMessage(), (Throwable)exception);
                logger.info("\u6052\u4e30\u94f6\u884c\u56de\u5355\u4e0b\u8f7d\u5931\u8d25..\uff0c\u5931\u8d25\u539f\u56e0:" + exception.getMessage());
                throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u6052\u4e30\u94f6\u884c\u56de\u5355\u4e0b\u8f7d\u5931\u8d25..\uff0c\u5931\u8d25\u539f\u56e0:%s", (String)"BankReceiptDownloadImpl_3", (String)"ebg-receipt-banks-hfb-dc", (Object[])new Object[0]), exception.getMessage()), (Throwable)exception);
            }
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "HFB_DC_BankReceiptDownload";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6052\u4e30\u94f6\u884c\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d", (String)"BankReceiptDownloadImpl_2", (String)"ebg-receipt-banks-hfb-dc", (Object[])new Object[0]);
    }
}

