/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.hfb.dc.service.receipt;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.hfb.dc.service.receipt.HFBDcCommConfig;
import kd.ebg.receipt.banks.hfb.dc.service.receipt.api.DownloadFileImpl;
import kd.ebg.receipt.banks.hfb.dc.service.receipt.api.HFBDcReceiptQueryRequest;
import kd.ebg.receipt.banks.hfb.dc.service.receipt.api.ReceiptFileQueryImpl;
import kd.ebg.receipt.banks.hfb.dc.service.receipt.api.ReceiptInfoQueryImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.ReceiptInfo;
import kd.ebg.receipt.business.receipt.bank.ReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.ReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        List<DownloadListDetail> result = new ArrayList(16);
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        if (Objects.equals(HFBDcCommConfig.getInstance().getRECEIPT_PUSH_CHANNEL(), "MASTER")) {
            ReceiptInfoQueryImpl receiptInfoQuery = new ReceiptInfoQueryImpl();
            ReceiptRequest receiptRequest = new ReceiptRequest();
            receiptRequest.setAccNo(accNo);
            receiptRequest.setStartDate(transDate);
            receiptRequest.setEndDate(transDate);
            ReceiptResponseEB receiptResponseEB = receiptInfoQuery.queryReceipt(receiptRequest);
            List receiptList = receiptResponseEB.getReceiptInfos();
            String filePathPre = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"HFB_DC", (String)accNo, (String)transDateStr);
            for (ReceiptInfo info : receiptList) {
                String oppAccNo = info.getOppAccNo();
                String cdFlag = info.getTransNetCode();
                String amount = info.getRemark();
                String serialNo = info.getTranSerialNo();
                StringBuilder fileNameBuilder = new StringBuilder();
                fileNameBuilder.append(accNo).append("_");
                fileNameBuilder.append(transDateStr).append("_");
                fileNameBuilder.append(serialNo).append("_");
                fileNameBuilder.append(amount).append("_");
                fileNameBuilder.append(cdFlag).append("_");
                fileNameBuilder.append(oppAccNo).append(".pdf");
                String newFileName = fileNameBuilder.toString();
                BankReceiptRequest receiptFileQueryRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).requestStr(serialNo).build();
                ReceiptFileQueryImpl receiptFileQuery = new ReceiptFileQueryImpl();
                BankReceiptResponseEB receiptFileQueryResponseEB = receiptFileQuery.doBiz(receiptFileQueryRequest);
                String fileName = (String)receiptFileQueryResponseEB.getData();
                DownloadFileImpl downloadFile = new DownloadFileImpl();
                HashMap runningParams = Maps.newHashMapWithExpectedSize((int)4);
                runningParams.put("fileName", fileName);
                runningParams.put("newFileName", newFileName);
                runningParams.put("savePath", filePathPre);
                EBContext.getContext().setRunningParams((Map)runningParams);
                BankReceiptRequest downloadFileRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).requestStr(fileName).build();
                downloadFile.doBiz(downloadFileRequest);
                DownloadListDetail downloadListDetail = new DownloadListDetail();
                downloadListDetail.setFileName(newFileName);
                downloadListDetail.setFileLink(fileName);
                result.add(downloadListDetail);
            }
        } else {
            BankReceiptRequest bankDetailRequest = BankReceiptRequest.builder().transDate(request.getTransDate()).accNo(accNo).build();
            HFBDcReceiptQueryRequest hfbDcReceiptQueryRequest = new HFBDcReceiptQueryRequest();
            BankReceiptResponseEB bankReceiptResponseEB = (BankReceiptResponseEB)hfbDcReceiptQueryRequest.doBiz((BankRequest)bankDetailRequest);
            result = (List)bankReceiptResponseEB.getData();
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-hfb-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "HFB_DC_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u6052\u4e30\u94f6\u884c\u56de\u5355\u6587\u4ef6\u5217\u8868\u3002", (String)"BankReceiptFetchListImpl_1", (String)"ebg-receipt-banks-hfb-dc", (Object[])new Object[0]);
    }
}

