/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.hfb.dc.service.receipt.api;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.hfb.dc.service.receipt.login.LoginAccess;
import kd.ebg.receipt.banks.hfb.dc.service.receipt.login.LoginAccessManager;
import kd.ebg.receipt.banks.hfb.dc.service.receipt.utils.HFB_Packer;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import org.jdom2.Element;

public class DownloadFileImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DownloadFileImpl.class);

    public String pack(BankReceiptRequest bankReceiptRequest) {
        Map runningParams = EBContext.getContext().getRunningParams();
        String fileName = (String)runningParams.get("fileName");
        Element root = HFB_Packer.buildHead(Sequence.gen14Sequence());
        Element opReq = root.getChild("opReq");
        Element reqParam = JDomUtils.addChild((Element)opReq, (String)"reqParam");
        JDomUtils.addChild((Element)reqParam, (String)"SOURCE", (String)fileName);
        JDomUtils.addChild((Element)reqParam, (String)"FILEPATH", (String)"CCMSHD");
        JDomUtils.addChild((Element)reqParam, (String)"LOCAL_REMOTE", (String)"0");
        String rqstStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)"GBK");
        rqstStr = rqstStr.replaceAll("\n", "");
        rqstStr = rqstStr.replaceAll("\r", "");
        rqstStr = rqstStr.replaceAll(" ", "");
        rqstStr = "<?xml version=\"1.0\" encoding=\"GBK\"?>" + rqstStr;
        EBContext.getContext().setRemoveWriteResponseLog(true);
        return rqstStr;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String rspStr) {
        EBContext.getContext().setRemoveWriteResponseLog(false);
        return BankReceiptResponseEB.success();
    }

    public String recv(InputStream inputStream) {
        Map runningParams = EBContext.getContext().getRunningParams();
        String savePath = (String)runningParams.get("savePath");
        String fileName = (String)runningParams.get("newFileName");
        try {
            byte[] getData = this.readInputStream(inputStream);
            String string = new String(getData);
            if (string.length() < 1000) {
                logger.info("\u54cd\u5e94\u6570\u636e\uff1a{}", (Object)string);
            }
            if (EBGStringUtils.isEmpty((String)string)) {
                throw new ReceiptException(ResManager.loadKDString((String)"6W0111\u63a5\u53e3\u54cd\u5e94\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u94f6\u884c\u5904\u7406", (String)"DownloadFileImpl_1", (String)"ebg-receipt-banks-hfb-dc", (Object[])new Object[0]));
            }
            File saveDir = FileCommonUtils.getFileByPath((String)savePath);
            if (!saveDir.exists()) {
                saveDir.mkdirs();
            }
            File file = FileCommonUtils.getFileByPath((String)(saveDir + File.separator + fileName));
            try (FileOutputStream fos = new FileOutputStream(file);){
                fos.write(getData);
            }
        }
        catch (Exception e) {
            throw new ReceiptException((Throwable)e);
        }
        return "";
    }

    private byte[] readInputStream(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[1024];
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int len;
            while ((len = inputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    public String getDeveloper() {
        return "LW";
    }

    public String getBizCode() {
        return "6W0111";
    }

    public String getBizDesc() {
        return null;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-java-serialized-object; charset=GBK");
        factory.setHttpHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/108.0.0.0 Safari/537.36 Edg/108.0.1462.54");
        factory.setHttpHeader("Accept-Encoding", "identity, gzip, deflate, br");
        factory.setProtocol("HTTP");
        EBContext.getContext().setCharsetName("GBK");
        LoginAccess la = LoginAccessManager.searchLock();
        String token = la.getToken();
        factory.setUri("/HFYQService/APIReqServlet?dse_sessionId=" + token + "&opName=" + this.getBizCode());
    }
}

