/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.hfb.dc.service.receipt.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.security.manage.APICipherSecurity;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.banks.hfb.dc.service.receipt.HFBDcCommConfig;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class HFBDcReceiptQueryRequest
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(HFBDcReceiptQueryRequest.class);

    public String pack(BankReceiptRequest bankDetailRequest) {
        String accNo = bankDetailRequest.getAccNo();
        String transDateStr = bankDetailRequest.getTransDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("accountNo", (Object)accNo);
        jsonObject.put("startTime", (Object)(transDateStr + "000000"));
        jsonObject.put("endTime", (Object)(transDateStr + "235959"));
        String singStr = jsonObject.toJSONString();
        APICipherSecurity security = (APICipherSecurity)SpringContextUtil.getBean(APICipherSecurity.class);
        String bankLoginId = EBContext.getContext().getBankLoginID();
        HFBDcCommConfig hfbDcCommConfig = (HFBDcCommConfig)EBConfigBuilder.getInstance().buildConfig(HFBDcCommConfig.class, bankLoginId);
        String encryptAES = security.encryptAES(singStr, hfbDcCommConfig.getSIGN_CIPHER());
        JSONObject body = new JSONObject();
        body.put("timeStamp", (Object)System.currentTimeMillis());
        body.put("sign", (Object)encryptAES);
        body.put("data", (Object)jsonObject);
        String receiptRequest = body.toJSONString();
        return receiptRequest;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        String accNo = request.getAccNo();
        String transDate = request.getTransDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JSONObject responseStrJson = JSONObject.parseObject((String)responseStr);
        String code = responseStrJson.getString("code");
        String message = responseStrJson.getString("message");
        if (!Objects.equals(code, "200")) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u63a5\u53e3\u8fd4\u56de\u9519\u8bef-\u54cd\u5e94\u7801\uff1a%1$s-\u54cd\u5e94\u5185\u5bb9\uff1a%2$s\u3002", (String)"HFBDcReceiptQueryRequest_3", (String)"ebg-receipt-banks-hfb-dc", (Object[])new Object[0]), code, message));
        }
        JSONObject dataJson = responseStrJson.getJSONObject("data");
        JSONArray fileList = dataJson.getJSONArray("fileList");
        logger.info("\u6052\u4e30\u94f6\u884c\u2014\u2014\u56de\u5355\u67e5\u8be2\u54cd\u5e94-{}-{}-\u56de\u5355\u6570\u91cf\uff1a{}", new Object[]{accNo, transDate, fileList.size()});
        String bankLoginId = EBContext.getContext().getBankLoginID();
        HFBDcCommConfig hfbDcCommConfig = (HFBDcCommConfig)EBConfigBuilder.getInstance().buildConfig(HFBDcCommConfig.class, bankLoginId);
        boolean isOnlyModel = StringUtils.isNotEmpty((String)hfbDcCommConfig.getRECEIPT_PROXY_IP());
        ArrayList<DownloadListDetail> details = new ArrayList<DownloadListDetail>(16);
        for (int i = 0; i < fileList.size(); ++i) {
            JSONObject fileInfo = fileList.getJSONObject(i);
            String hostSeqNo = fileInfo.getString("hostSeqNo");
            String url = fileInfo.getString("url");
            String fileName = accNo + "_" + transDate + "_" + hostSeqNo + ".pdf";
            DownloadListDetail downloadListDetail = new DownloadListDetail();
            downloadListDetail.setFileName(fileName);
            if (isOnlyModel && StringUtils.isNotEmpty((String)url)) {
                String proxyIp = hfbDcCommConfig.getRECEIPT_PROXY_IP();
                String proxyPort = hfbDcCommConfig.getRECEIPT_PROXY_PORT() + "";
                String[] arrays = url.split(":");
                if (arrays.length >= 2) {
                    String ip = arrays[1].replace("//", "");
                    String[] ports = arrays[2].split("/");
                    if (ports.length >= 1) {
                        String port = ports[0];
                        String urlExp = url.replace(ip, "%s").replace(":" + port, ":%s");
                        url = String.format(urlExp, proxyIp, proxyPort);
                        logger.info("\u4e13\u7ebf\u6a21\u5f0f\u8f6c\u6362\u540e\u7684\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d\u94fe\u63a5\uff1a{}", (Object)url);
                    }
                }
            }
            downloadListDetail.setFileLink(url);
            details.add(downloadListDetail);
        }
        return BankReceiptResponseEB.success(details);
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u67e5\u8be2", (String)"HFBDcReceiptQueryRequest_1", (String)"ebg-receipt-banks-hfb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        String bankLoginId = EBContext.getContext().getBankLoginID();
        HFBDcCommConfig hfbDcCommConfig = (HFBDcCommConfig)EBConfigBuilder.getInstance().buildConfig(HFBDcCommConfig.class, bankLoginId);
        factory.setUri(hfbDcCommConfig.getRECEIPT_URI());
        factory.setPort(hfbDcCommConfig.getRECEIPT_PORT() + "");
        factory.setIp(hfbDcCommConfig.getRECEIPT_IP());
        factory.setHttpHeader("content-type", "application/json");
    }
}

