/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.hfb.dc.service.receipt.api;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.hfb.dc.service.receipt.login.LoginAccess;
import kd.ebg.receipt.banks.hfb.dc.service.receipt.login.LoginAccessManager;
import kd.ebg.receipt.banks.hfb.dc.service.receipt.utils.HFB_Packer;
import kd.ebg.receipt.banks.hfb.dc.service.receipt.utils.HFB_Parser;
import kd.ebg.receipt.business.receipt.atom.AbstractReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IReceipt;
import kd.ebg.receipt.business.receipt.bank.ReceiptInfo;
import kd.ebg.receipt.business.receipt.bank.ReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.ReceiptResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import org.jdom2.Element;

public class ReceiptInfoQueryImpl
extends AbstractReceiptImpl
implements IReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptInfoQueryImpl.class);

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "NWHD01";
    }

    public String getBizDesc() {
        return "";
    }

    public ReceiptResponseEB queryReceipt(ReceiptRequest request) {
        ReceiptResponseEB responseEB = new ReceiptResponseEB();
        ArrayList receiptInfos = new ArrayList(16);
        this.setCurrentPage(1);
        while (!this.isLastPage()) {
            responseEB = this.doBiz(request);
            if (responseEB == null || responseEB.getReceiptInfos().isEmpty()) continue;
            receiptInfos.addAll(responseEB.getReceiptInfos());
        }
        if (Objects.nonNull(responseEB)) {
            responseEB.setReceiptInfos(receiptInfos);
        }
        return responseEB;
    }

    public String pack(ReceiptRequest request) {
        String currentPage = this.getCurrentPage();
        Element root = HFB_Packer.buildHead(Sequence.gen14Sequence());
        Element opReq = root.getChild("opReq");
        Element reqParam = JDomUtils.addChild((Element)opReq, (String)"reqParam");
        String accNo = request.getAccNo();
        JDomUtils.addChild((Element)reqParam, (String)"ACC_NO", (String)accNo);
        JDomUtils.addChild((Element)reqParam, (String)"STARTDATE", (String)LocalDateUtil.formatDate((LocalDate)request.getStartDate(), (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)reqParam, (String)"ENDDATE", (String)LocalDateUtil.formatDate((LocalDate)request.getEndDate(), (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)reqParam, (String)"PAGE", (String)currentPage);
        JDomUtils.addChild((Element)reqParam, (String)"TOTAL_RECORD", (String)"20");
        JDomUtils.addChild((Element)reqParam, (String)"PRINT_FLAG", (String)"");
        String rqstStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)"GBK");
        rqstStr = rqstStr.replaceAll("\n", "");
        rqstStr = rqstStr.replaceAll("\r", "");
        rqstStr = rqstStr.replaceAll(" ", "");
        rqstStr = "<?xml version=\"1.0\" encoding=\"GBK\"?>" + rqstStr;
        return rqstStr;
    }

    public ReceiptResponseEB parse(ReceiptRequest request, String responseStr) {
        String total_page;
        ReceiptResponseEB response = new ReceiptResponseEB();
        response.setCompleteFlag(0);
        String encoding = "GBK";
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = HFB_Parser.parserHead(root);
        if (!"000000".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u56de\u5355\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s,%2$s", (String)"ReceiptInfoQueryImpl_0", (String)"ebg-receipt-banks-hfb-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element txInfo = root.getChild("TX_INFO");
        String page = txInfo.getChildText("PAGE");
        if (Objects.equals(page, total_page = txInfo.getChildText("TOTAL_PAGE")) || Objects.equals(total_page, "0")) {
            this.setLastPage(true);
        } else {
            String currentPage = this.getCurrentPage();
            String nextCurrentPage = Integer.toString(Integer.parseInt(currentPage) + 1);
            this.setCurrentPage(nextCurrentPage);
        }
        List list = txInfo.getChildren("DETAILLIST");
        ArrayList<ReceiptInfo> receiptInfoList = new ArrayList<ReceiptInfo>(16);
        String accNo = request.getAccNo();
        for (Element row : list) {
            ReceiptInfo rInfo = new ReceiptInfo();
            String transDate = row.getChildTextTrim("TRAN_DATE");
            String logNo = row.getChildTextTrim("LOG_NO");
            String crCod = row.getChildTextTrim("CR_COD");
            String amount = row.getChildTextTrim("TX_AMT");
            String OP_ACCT_NO = row.getChildTextTrim("OP_ACCT_NO");
            String currency = row.getChildTextTrim("CCYCD");
            if (StringUtils.isEmpty((String)logNo)) {
                logger.info("\u5b58\u5728\u4e00\u7b14\u6d41\u6c34\u53f7\u4e3a\u7a7a\u7684\u8bb0\u5f55\uff0c\u5df2\u8df3\u8fc7");
                continue;
            }
            rInfo.setAccNo(accNo);
            rInfo.setOppAccNo(OP_ACCT_NO);
            rInfo.setCurrency(currency);
            rInfo.setTransNetCode(crCod);
            rInfo.setRemark(amount);
            rInfo.setTranSerialNo(logNo);
            rInfo.setTransDate(transDate);
            receiptInfoList.add(rInfo);
        }
        response.setReceiptInfos(receiptInfoList);
        response.setCompleteFlag(1);
        return response;
    }

    public boolean match(ReceiptRequest request) {
        return false;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setProtocol("HTTP");
        EBContext.getContext().setCharsetName("GBK");
        factory.setHttpHeader("content-type", "text/xml; charset=GBK");
        LoginAccess la = LoginAccessManager.searchLock();
        String token = la.getToken();
        factory.setUri("/HFYQService/APIReqServlet?dse_sessionId=" + token + "&opName=" + this.getBizCode());
    }
}

