/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.hfb.dc.service.receipt.login;

import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.banks.hfb.dc.service.receipt.login.LoginPacker;
import kd.ebg.receipt.banks.hfb.dc.service.receipt.login.LoginParser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.utils.FileCommonUtils;

public class LoginImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private EBGLogger log = EBGLogger.getInstance().getLogger(LoginImpl.class);
    private static final int timeout = 600;

    public String getToken() throws EBServiceException {
        String key = this.getCacheKey();
        String cache_token = CosmicCache.get((String)key);
        boolean unitTest = FileCommonUtils.isTestEnv();
        if (unitTest) {
            return "testToken";
        }
        if (StringUtils.isEmpty((String)cache_token)) {
            DLock lock = DLock.create((String)key, (String)ResManager.loadKDString((String)"\u6052\u4e30\u94f6\u884c\u83b7\u53d6\u767b\u5f55token\u5206\u5e03\u5f0f\u9501\u3002", (String)"LoginImpl_0", (String)"ebg-receipt-banks-hfb-dc", (Object[])new Object[0]));
            try {
                if (lock.tryLock()) {
                    cache_token = CosmicCache.get((String)key);
                    if (StringUtils.isEmpty((String)cache_token)) {
                        cache_token = this.login();
                    }
                } else {
                    long time;
                    for (time = 180000L; time >= 0L && !StringUtils.isNotEmpty((String)(cache_token = CosmicCache.get((String)key))); time -= 700L) {
                        Thread.sleep(700L);
                    }
                    if (time < 0L) {
                        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u6052\u4e30\u94f6\u884ctoken\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u53d1\u8d77\u8bf7\u6c42\u3002", (String)"LoginImpl_1", (String)"ebg-receipt-banks-hfb-dc", (Object[])new Object[0]));
                    }
                }
            }
            catch (Exception e) {
                this.log.error("\u83b7\u53d6\u6052\u4e30\u94f6\u884ctoken\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u6052\u4e30\u94f6\u884ctoken\u51fa\u73b0\u5f02\u5e38\u3002", (String)"LoginImpl_2", (String)"ebg-receipt-banks-hfb-dc", (Object[])new Object[0]), (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        }
        return cache_token;
    }

    public String getCacheKey() {
        String customID = EBContext.getContext().getCustomID();
        String bankLoginID = EBContext.getContext().getBankLoginID();
        return "eb_" + customID + "_" + bankLoginID + "_token";
    }

    private String login() throws EBServiceException {
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().build();
        return (String)this.doBiz(bankReceiptRequest).getData();
    }

    public String pack(BankReceiptRequest bankReceiptRequest) {
        LoginPacker loginPacker = new LoginPacker();
        String rqstStr = loginPacker.packLogin();
        this.log.info("\u6052\u4e30\u94f6\u884c\u767b\u5f55\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)rqstStr);
        return rqstStr;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String responseStr) {
        this.log.info("\u6052\u4e30\u94f6\u884c\u767b\u5f55\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)responseStr);
        LoginParser loginParser = new LoginParser();
        String token = loginParser.parseLogin(responseStr);
        CosmicCache.putIfAbsentWithExpire((String)this.getCacheKey(), (String)token, (int)600, (TimeUnit)TimeUnit.SECONDS);
        return BankReceiptResponseEB.success((Object)token);
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "CebankUserLogonOp";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u767b\u5f55\u63a5\u53e3", (String)"LoginImpl_3", (String)"ebg-receipt-banks-hfb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setProtocol("HTTP");
        EBContext.getContext().setCharsetName("GBK");
        factory.setUri("/HFYQService/APISessionReqServlet?opName=CebankUserLogonOp");
        factory.setHttpHeader("content-type", "text/xml; charset=GBK");
    }
}

