/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.xib.dc.service.receipt;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.xib.dc.service.receipt.api.BankReceiptDownloadRequestImpl;
import kd.ebg.receipt.banks.xib.dc.service.receipt.api.GetBankReceiptListRequestImpl;
import kd.ebg.receipt.banks.xib.dc.service.receipt.vo.ReceiptInfoResp;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest bankReceiptHandleRequest) {
        this.init(bankReceiptHandleRequest);
        long taskId = bankReceiptHandleRequest.getTaskId();
        DownloadListTask task = this.downloadTaskService.findById(taskId);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        String accNo = task.getAccNo();
        LocalDate transDate = task.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)task.getTransDate());
        int pageNo = 1;
        List<ReceiptInfoResp> receiptInfoRespList = this.getReceiptList(pageNo, accNo, transDate);
        HashMap existReceiptFileName = Maps.newHashMapWithExpectedSize((int)1);
        for (ReceiptInfoResp receiptInfoResp : receiptInfoRespList) {
            String uniqueCode = receiptInfoResp.getUniqueCode();
            String ecmBatchNo = receiptInfoResp.getEcmBatchNo();
            String txnReference = receiptInfoResp.getTxnReference();
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)8);
            paramMap.put("uniqueCode", uniqueCode);
            paramMap.put("ecmBatchNo", ecmBatchNo);
            BankReceiptRequest request = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).paramsMap((Map)paramMap).build();
            BankReceiptDownloadRequestImpl bankReceipt = new BankReceiptDownloadRequestImpl();
            BankReceiptResponseEB bankReceiptResponseEB = (BankReceiptResponseEB)bankReceipt.doBiz((BankRequest)request);
            String fileUrl = (String)bankReceiptResponseEB.getData();
            StringBuilder builder = new StringBuilder();
            builder.append(accNo).append("-").append(transDateStr).append("-").append(txnReference).append(".").append("pdf");
            String newFileName = builder.toString();
            if (existReceiptFileName.containsKey(newFileName)) {
                StringBuilder againStr = new StringBuilder();
                againStr.append(accNo).append("-").append(transDateStr).append("-").append(txnReference).append("-").append(uniqueCode).append(".").append("pdf");
                newFileName = againStr.toString();
            } else {
                existReceiptFileName.put(newFileName, newFileName);
            }
            DownloadListDetail detail = new DownloadListDetail();
            detail.setFileLink(fileUrl);
            detail.setFileName(newFileName);
            result.add(detail);
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-xib-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public List<ReceiptInfoResp> getReceiptList(int pageNo, String accNo, LocalDate transDate) {
        ArrayList<ReceiptInfoResp> receiptInfoResps = new ArrayList<ReceiptInfoResp>(16);
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)8);
        paramMap.put("pageNo", pageNo);
        BankReceiptRequest request = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).paramsMap((Map)paramMap).build();
        GetBankReceiptListRequestImpl bankReceipt = new GetBankReceiptListRequestImpl();
        BankReceiptResponseEB bankReceiptResponseEB = (BankReceiptResponseEB)bankReceipt.doBiz((BankRequest)request);
        String responseStr = (String)bankReceiptResponseEB.getData();
        JSONObject jsonObject = JSONObject.parseObject((String)responseStr);
        JSONObject body = jsonObject.getJSONObject("body");
        String totalNumberStr = body.getString("totalNumber");
        int total = Integer.parseInt(totalNumberStr);
        if (total == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u65e0\u56de\u5355\u8bb0\u5f55", (String)"BankReceiptFetchListImpl_1", (String)"ebg-receipt-banks-xib-dc", (Object[])new Object[0]));
        }
        JSONArray tradeDataList = body.getJSONArray("tradeDataList");
        for (int i = 0; i < tradeDataList.size(); ++i) {
            JSONObject receiptJson = tradeDataList.getJSONObject(i);
            String uniqueCode = receiptJson.getString("uniqueCode");
            String ecmBatchNo = receiptJson.getString("ecmBatchNo");
            String txnReference = receiptJson.getString("txnReference");
            ReceiptInfoResp receiptInfoResp = ReceiptInfoResp.builder().ecmBatchNo(ecmBatchNo).txnReference(txnReference).uniqueCode(uniqueCode).build();
            receiptInfoResps.add(receiptInfoResp);
        }
        if (total > pageNo * 10) {
            receiptInfoResps.addAll(this.getReceiptList(pageNo + 1, accNo, transDate));
        }
        return receiptInfoResps;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "XIB_DC_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u53a6\u95e8\u56fd\u9645\u94f6\u884c\u76f4\u8fde\u7248\u56de\u5355\u6587\u4ef6\u5217\u8868", (String)"BankReceiptFetchListImpl_2", (String)"ebg-receipt-banks-xib-dc", (Object[])new Object[0]);
    }
}

