/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bocom.dc.service.receipt;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.bocom.dc.service.receipt.BocomDcCommonConfig;
import kd.ebg.receipt.banks.bocom.dc.service.receipt.info.BocomReceipt;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.core.utils.GZFileUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ConnectionException;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.PropertiesConstantsUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import org.apache.commons.io.FileUtils;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest bankReceiptHandleRequest) {
        String batchUnZipPath;
        String batchPath;
        String bakPath;
        BankFtpProperties bankFtpProperties;
        String subZipName;
        String zipFileName;
        LocalDate transDate;
        String accNo;
        ArrayList<DownloadListDetail> result;
        DownloadListTask task;
        String sftp_path;
        ChannelSftp sftp;
        block17: {
            BankReceiptHandleResponseEB files;
            this.init(bankReceiptHandleRequest);
            long taskId = bankReceiptHandleRequest.getTaskId();
            sftp = null;
            sftp_path = "";
            task = this.downloadTaskService.findById(taskId);
            result = new ArrayList<DownloadListDetail>(16);
            accNo = task.getAccNo();
            String transDateStr = LocalDateUtil.formatDate((LocalDate)task.getTransDate());
            transDate = task.getTransDate();
            String bankLoginId = EBContext.getContext().getBankLoginID();
            String customNo = ((BocomDcCommonConfig)EBConfigBuilder.getInstance().buildConfig(BocomDcCommonConfig.class, bankLoginId)).getCustomNo();
            String queryDate = task.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE);
            zipFileName = customNo + "_" + queryDate + ".zip";
            subZipName = accNo + "_" + queryDate + ".zip";
            bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, task.getBankLoginId());
            if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                if (SFTPUtils.getInstance().isAbort(sftp)) {
                    sftp = SFTPUtils.getInstance().getSftp(task.getBankLoginId());
                }
                sftp_path = EBGStringUtils.isNotEmpty((String)(sftp_path = bankFtpProperties.getFtpPath())) ? sftp_path : "/";
            }
            bakPath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)task.getBankVersionId(), (String)accNo, (String)transDateStr);
            batchPath = FileStorageUtil.getFileBatchBakPathByTransDate((String)task.getBankVersionId(), (String)transDateStr);
            batchUnZipPath = batchPath + File.separator + customNo + "_" + queryDate;
            File bakFile = FileCommonUtils.getFileByPath((String)bakPath);
            if (!bakFile.exists() || bakFile.listFiles().length <= 0) break block17;
            for (File receiptFile : files = bakFile.listFiles()) {
                DownloadListDetail detail = new DownloadListDetail();
                detail.setFileLink(receiptFile.getName());
                detail.setFileName(receiptFile.getName());
                detail.setTransDate(task.getTransDate());
                result.add(detail);
            }
            RequestContextUtils.setZipName((String)subZipName);
            RequestContextUtils.setFileNum((int)((File[])files).length);
            BankReceiptHandleResponseEB bankReceiptHandleResponseEB = BankReceiptHandleResponseEB.success(result);
            SFTPUtils.getInstance().close(sftp);
            return bankReceiptHandleResponseEB;
        }
        try {
            if (!this.checkFileExist(bakPath, subZipName)) {
                BankReceiptApiUtil bankReceiptApiUtil;
                boolean flag;
                if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                    String sftpPath = sftp_path + "/" + zipFileName;
                    if (sftp != null && EBGStringUtils.isNotEmpty((String)sftpPath)) {
                        SftpATTRS sftpATTRS = sftp.stat(sftpPath);
                        if (sftpATTRS == null) throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u94f6\u884cSFTP\u6587\u4ef6[%s]\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff1a1\u3001\u94f6\u884cSFTP\u6839\u76ee\u5f55\u662f\u5426\u7ed1\u5b9a\u6b63\u786e\uff1b2\u3001\u786e\u8ba4\u94f6\u884c\u662f\u5426\u5df2\u63a8\u9001\u8be5\u6587\u4ef6\u3002", (String)"BankReceiptFetchListImpl_18", (String)"ebg-receipt-banks-bocom-dc", (Object[])new Object[0]), zipFileName));
                        boolean flag2 = SFTPUtils.getInstance().downloadSingleFile(sftp_path, zipFileName, batchPath, sftp);
                        if (!flag2) {
                            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u603b\u5305\u6587\u4ef6[%s]\u4e0b\u8f7d\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4ea4\u884cSFTP\u76ee\u5f55\u662f\u5426\u5b58\u5728\u8be5\u6587\u4ef6\u3002", (String)"BankReceiptFetchListImpl_17", (String)"ebg-receipt-banks-bocom-dc", (Object[])new Object[0]), zipFileName));
                        }
                    }
                } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login") && !(flag = (bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate)).downloadReceiptFile(zipFileName, batchPath))) {
                    throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u603b\u5305\u6587\u4ef6[%s]\u4e0b\u8f7d\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4ea4\u884c\u524d\u7f6e\u673a\u76ee\u5f55\u662f\u5426\u5b58\u5728\u8be5\u6587\u4ef6\u3002", (String)"BankReceiptFetchListImpl_19", (String)"ebg-receipt-banks-bocom-dc", (Object[])new Object[0]), zipFileName));
                }
                if (!GZFileUtils.unZipFiles((String)(batchPath + File.separator + zipFileName), (String)batchUnZipPath)) throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u603b\u5305\u6587\u4ef6[%s]\u89e3\u538b\u7f29\u5931\u8d25\u3002", (String)"BankReceiptFetchListImpl_20", (String)"ebg-receipt-banks-bocom-dc", (Object[])new Object[0]), zipFileName));
                boolean isDelete = FileCommonUtils.getFileByPath((String)(batchPath + File.separator + zipFileName)).delete();
                logger.info("\u6587\u4ef6\u540d\uff1a{}\uff0c\u662f\u5426\u5220\u9664\uff1a{}", new Object[]{zipFileName, isDelete});
            }
            if (!this.checkFileExist(batchUnZipPath, subZipName)) {
                throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u56de\u5355\u6587\u4ef6\u5305[%s]\u4e0d\u5b58\u5728\uff0c\u94f6\u884c\u672a\u63a8\u9001\u3002", (String)"BankReceiptFetchListImpl_21", (String)"ebg-receipt-banks-bocom-dc", (Object[])new Object[0]), subZipName));
            }
            String subFileDir = batchUnZipPath + File.separator + subZipName.replace(".zip", "");
            if (!GZFileUtils.unZipFiles((String)(batchUnZipPath + File.separator + subZipName), (String)subFileDir)) throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u5b50\u5305\u6587\u4ef6[%s]\u89e3\u538b\u7f29\u5931\u8d25\u3002", (String)"BankReceiptFetchListImpl_23", (String)"ebg-receipt-banks-bocom-dc", (Object[])new Object[0]), subZipName));
            File file = FileCommonUtils.getFileByPath((String)(subFileDir + File.separator + subZipName.replace(".zip", ".txt")));
            if (!file.isFile() || !file.exists()) throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u5b50\u5305\u6c47\u603b\u6587\u4ef6[%s]\u7f3a\u5931\uff0c\u56de\u5355\u65e0\u6cd5\u89e3\u6790\u3002", (String)"BankReceiptFetchListImpl_22", (String)"ebg-receipt-banks-bocom-dc", (Object[])new Object[0]), subZipName.replace(".zip", ".txt")));
            List<BocomReceipt> receipts = this.parse(subFileDir, subZipName, accNo);
            for (BocomReceipt receipt : receipts) {
                DownloadListDetail detail = new DownloadListDetail();
                detail.setFileLink(receipt.getFileName());
                detail.setFileName(receipt.getReceiptName());
                detail.setTransDate(task.getTransDate());
                result.add(detail);
                File oldFile = FileCommonUtils.getFileByPath((String)(subFileDir + File.separator + receipt.getFileName()));
                BankReceiptFetchListImpl.moveFile(oldFile, bakPath, receipt.getReceiptName());
            }
            this.deleteDir(file.getParentFile());
            boolean isDelete = FileCommonUtils.getFileByPath((String)(batchUnZipPath + File.separator + subZipName)).delete();
            logger.info("\u6587\u4ef6\u540d\uff1a{}\uff0c\u662f\u5426\u5220\u9664\uff1a{}", new Object[]{subZipName, isDelete});
        }
        catch (Exception e) {
            try {
                if (!(e instanceof ConnectionException)) throw new ReceiptException((Throwable)e);
                throw (ConnectionException)e;
            }
            catch (Throwable throwable) {
                SFTPUtils.getInstance().close(sftp);
                throw throwable;
            }
        }
        SFTPUtils.getInstance().close(sftp);
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_11", (String)"ebg-receipt-banks-bocom-dc", (Object[])new Object[0]));
        }
        RequestContextUtils.setZipName((String)subZipName);
        return BankReceiptHandleResponseEB.success(result);
    }

    private boolean checkFileExist(String filePath, String fileName) {
        boolean flag = true;
        try {
            File file = FileCommonUtils.getFileByPath((String)(filePath + File.separator + fileName));
            flag = file.exists();
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    public static boolean moveFile(File file, String newFilePath, String newFileName) {
        boolean isSuccess = file.renameTo(FileCommonUtils.getFileByPath((String)(newFilePath + File.separator + newFileName)));
        File newNameFile = FileCommonUtils.getFileByPath((String)(newFilePath + File.separator + newFileName));
        if (!isSuccess) {
            try {
                FileUtils.moveFile((File)file, (File)newNameFile);
                File newFile = FileCommonUtils.getFileByPath((String)(newFilePath + File.separator + newFileName));
                isSuccess = true;
                if (!newFile.exists()) {
                    isSuccess = BankReceiptFetchListImpl.copyFolder(file, newFilePath, newFileName);
                }
            }
            catch (IOException e) {
                logger.error("\u6587\u4ef6\u79fb\u52a8\u9519\u8bef\uff1a{}", new Object[]{e.getMessage()});
            }
        }
        return isSuccess;
    }

    public static boolean copyFolder(File in, String newFilePath, String newFileName) {
        File out = FileCommonUtils.getFileByPath((String)newFilePath);
        if (!in.exists()) {
            logger.error(in.getAbsolutePath() + "\u6e90\u6587\u4ef6\u8def\u5f84\u9519\u8bef\uff01\uff01\uff01");
            return false;
        }
        if (!out.exists()) {
            out.mkdirs();
        }
        try (FileInputStream fis = new FileInputStream(in);
             FileOutputStream fos = new FileOutputStream(FileCommonUtils.getFileByPath((String)(newFilePath + File.separator + newFileName)));){
            int c;
            byte[] b = new byte[5120];
            while ((c = fis.read(b)) != -1) {
                fos.write(b, 0, c);
            }
            fos.flush();
        }
        catch (IOException e) {
            logger.error("copyFolder-error-IOException:{}", new Object[]{e.getMessage()});
            return false;
        }
        return true;
    }

    private List<BocomReceipt> parse(String subFileDir, String subZipName, String accNo) {
        ArrayList<BocomReceipt> bocomReceiptList = new ArrayList<BocomReceipt>(16);
        boolean isNew = false;
        String txtName = subZipName.replace(".zip", "") + ".txt";
        File sourceFile = FileCommonUtils.getFileByPath((String)(subFileDir + File.separator + txtName));
        try (InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(sourceFile), "utf-8");
             BufferedReader br = new BufferedReader(isr);){
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith(PropertiesConstantsUtils.getValue((String)"BOCOM_RECEIPT_DATE")) || line.startsWith(PropertiesConstantsUtils.getValue((String)"BOCOM_RECEIPT_DATE_CHAR"))) {
                    String[] fields = EBGStringUtils.split((String)line, (String)"|!");
                    if (fields.length <= 4) continue;
                    String fourWord = fields[3];
                    isNew = Objects.equals(PropertiesConstantsUtils.getValue((String)"BOCOM_RECEIPT_SEQ"), fourWord);
                    continue;
                }
                BocomReceipt receipt = BocomReceipt.parse(line, accNo, isNew);
                if (receipt == null) continue;
                bocomReceiptList.add(receipt);
            }
        }
        catch (Exception e) {
            throw new ReceiptException((Throwable)e);
        }
        return bocomReceiptList;
    }

    private void deleteDir(File file) {
        if (file.isFile()) {
            boolean isDelete = file.delete();
            logger.info("\u6587\u4ef6\u540d\uff1a{}-\u662f\u5426\u88ab\u5220\u9664\uff1a{}", new Object[]{file.getName(), isDelete});
        } else {
            File[] files = file.listFiles();
            if (files == null) {
                boolean isDelete = file.delete();
                logger.info("\u6587\u4ef6\u540d\uff1a{}-\u662f\u5426\u88ab\u5220\u9664\uff1a{}", new Object[]{file.getName(), isDelete});
            } else {
                for (int i = 0; i < files.length; ++i) {
                    this.deleteDir(files[i]);
                }
                boolean isDelete = file.delete();
                logger.info("\u6587\u4ef6\u540d\uff1a{}-\u662f\u5426\u88ab\u5220\u9664\uff1a{}", new Object[]{file.getName(), isDelete});
            }
        }
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "BOCOM_DC_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u4ea4\u901a\u94f6\u884c\u76f4\u8fde\u7248\u56de\u5355\u6587\u4ef6\u5217\u8868", (String)"BankReceiptFetchListImpl_16", (String)"ebg-receipt-banks-bocom-dc", (Object[])new Object[0]);
    }
}

