/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.eves.dc.receipt.api;

import java.util.Map;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.receipt.banks.eves.dc.receipt.helper.EvesSignature;
import kd.ebg.receipt.banks.eves.dc.receipt.helper.Packer;
import kd.ebg.receipt.banks.eves.dc.receipt.helper.Parser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import org.jdom2.Element;

public class ReceiptDownloadRequestImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptDownloadRequestImpl.class);

    public String pack(BankReceiptRequest request) {
        Map paramsMap = request.getParamsMap();
        String currency = request.getAcnt().getCurrency();
        String vouNo = (String)paramsMap.get("vouNo");
        String vouDate = (String)paramsMap.get("vouDate");
        Element root = Packer.packT1001(request, currency, vouNo, vouDate);
        String xmlStr = Packer.rootToString(root);
        String signStr = EvesSignature.getInstance().sign(xmlStr);
        xmlStr = Packer.packCommonWithSign(xmlStr, signStr);
        return xmlStr;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String responseStr) {
        String xmlStr = Parser.parseXmlOutSign(responseStr);
        String signStr = Parser.parseSignStr(responseStr);
        EvesSignature.getInstance().checkSign(xmlStr, signStr);
        Element root = Parser.stringToElement(xmlStr);
        Parser.parserHead(root);
        String fileContent = Parser.parseT1001(root);
        return BankReceiptResponseEB.success((Object)fileContent);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "T1001";
    }

    public String getBizDesc() {
        return null;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri(String.format("%s/%s", RequestContextUtils.getRunningParam((String)"receipt_uri"), this.getBizCode()));
        factory.setHttpHeader("Content-Type", "text/xml; charset=UTF-8");
        factory.setIp(RequestContextUtils.getRunningParam((String)"receipt_ip"));
        factory.setPort(RequestContextUtils.getRunningParam((String)"receipt_port"));
        factory.setProtocol(RequestContextUtils.getRunningParam((String)"receipt_protocol"));
    }
}

