/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.eves.dc.receipt.api;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.receipt.banks.eves.dc.receipt.helper.EvesSignature;
import kd.ebg.receipt.banks.eves.dc.receipt.helper.Packer;
import kd.ebg.receipt.banks.eves.dc.receipt.helper.Parser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.ReceiptInfo;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import org.jdom2.Element;

public class ReceiptQueryImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptQueryImpl.class);
    private static final String FORMAT = "yyyyMMdd";

    public String pack(BankReceiptRequest request) {
        Element root = Packer.packT2003(request, request.getAcnt().getCurrency(), this.getCurrentPage());
        String xmlStr = Packer.rootToString(root);
        String signStr = EvesSignature.getInstance().sign(xmlStr);
        xmlStr = Packer.packCommonWithSign(xmlStr, signStr);
        return xmlStr;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String responseStr) {
        String xmlStr = Parser.parseXmlOutSign(responseStr);
        String signStr = Parser.parseSignStr(responseStr);
        EvesSignature.getInstance().checkSign(xmlStr, signStr);
        Element root = Parser.stringToElement(xmlStr);
        Parser.parserHead(root);
        List<ReceiptInfo> receiptInfos = Parser.parseT2003(root);
        return BankReceiptResponseEB.success(receiptInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "T2003";
    }

    public String getBizDesc() {
        return null;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri(String.format("%s/%s", RequestContextUtils.getRunningParam((String)"receipt_uri"), this.getBizCode()));
        factory.setHttpHeader("Content-Type", "text/xml; charset=UTF-8");
        factory.setIp(RequestContextUtils.getRunningParam((String)"receipt_ip"));
        factory.setPort(RequestContextUtils.getRunningParam((String)"receipt_port"));
        factory.setProtocol(RequestContextUtils.getRunningParam((String)"receipt_protocol"));
    }

    public List<ReceiptInfo> queryReceiptList(String accNo, LocalDate transDate, String bankCurrency) {
        BankReceiptRequest request = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).build();
        BankAcnt acnt = new BankAcnt();
        acnt.setAccNo(accNo);
        acnt.setCurrency(bankCurrency);
        BankHeader bankHeader = new BankHeader();
        bankHeader.setAcnt(acnt);
        request.setHeader(bankHeader);
        ArrayList<ReceiptInfo> detailInfos = new ArrayList<ReceiptInfo>(1);
        this.setCurrentPage("0");
        boolean lastPage = false;
        this.setLastPage(false);
        while (!lastPage) {
            BankReceiptResponseEB response = this.doBiz(request);
            List receiveItems = (List)response.getData();
            if (Objects.nonNull(response) && Objects.nonNull(receiveItems)) {
                detailInfos.addAll(receiveItems);
            }
            lastPage = this.isLastPage();
            int currentPageInt = Integer.parseInt(this.getCurrentPage());
            this.setCurrentPage(String.valueOf(currentPageInt + 1));
        }
        return detailInfos;
    }
}

