/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.eves.dc.receipt.download;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ebg.egf.common.cache.CosmicConstants;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.eves.dc.receipt.api.ReceiptDownloadRequestImpl;
import kd.ebg.receipt.banks.eves.dc.receipt.config.EvesBankBusinessProperties;
import kd.ebg.receipt.banks.eves.dc.receipt.helper.Packer;
import kd.ebg.receipt.banks.eves.dc.receipt.info.EvesReceiptFileParser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.MatchStatusEnum;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.ReceiptMatchUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class EvesReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(EvesReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "RECEIPT_DOWNLOAD";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(1);
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        ReceiptDownloadRequestImpl receiptDownloadRequest = new ReceiptDownloadRequestImpl();
        String filePathPre = FileStorageUtil.getFileBakPathByAccNoAndDate((String)request.getBankVersionId(), (String)accNo, (String)transDateStr);
        String bankCurrency = Packer.getBankCurrency(accNo);
        EvesBankBusinessProperties bankBusinessProperties = (EvesBankBusinessProperties)EBConfigBuilder.getInstance().buildConfig(EvesBankBusinessProperties.class);
        Packer.buildCurrentRunningParam(bankBusinessProperties);
        Map receiptParamsMap = ReceiptMatchUtils.getInstance().selectMustFiledByBankVersion(request.getBankVersionId());
        for (DownloadListDetail detail : downloadListDetails) {
            if (detail.getUploadFlag().intValue() != UploadStatusEnum.UPLOAD_SUCCESS.getId() || detail.getMatchFlag().intValue() != MatchStatusEnum.SUCCESS.getId()) {
                String fileLink = detail.getFileLink();
                JSONObject jsonObject = JSONObject.parseObject((String)fileLink);
                String vouNo = jsonObject.getString("vouNo");
                String vouDate = jsonObject.getString("vouDate");
                HashMap paramMap = Maps.newHashMapWithExpectedSize((int)16);
                paramMap.put("vouNo", vouNo);
                paramMap.put("vouDate", vouDate);
                BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).paramsMap((Map)paramMap).build();
                BankAcnt acnt = new BankAcnt();
                acnt.setAccNo(accNo);
                acnt.setCurrency(bankCurrency);
                BankHeader bankHeader = new BankHeader();
                bankHeader.setAcnt(acnt);
                bankReceiptRequest.setHeader(bankHeader);
                BankReceiptResponseEB receiptResponseEB = receiptDownloadRequest.doBiz(bankReceiptRequest);
                String fileContent = (String)receiptResponseEB.getData();
                FileCommonUtils.base64ToFile((String)fileContent, (String)(filePathPre + File.separator + detail.getFileName()));
                detail.setReceiptJson(this.packReceiptJson(detail.getFileName(), receiptParamsMap));
            }
            result.add(detail);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public String packReceiptJson(String fileName, Map<String, String> receiptParamsMap) {
        EvesReceiptFileParser evesReceiptFileParser = new EvesReceiptFileParser();
        evesReceiptFileParser.setFileName(fileName);
        String amount = evesReceiptFileParser.getAmount();
        String cdFlag = evesReceiptFileParser.getCdFlag();
        String receiptNo = evesReceiptFileParser.getReceiptNo();
        String oppAccNo = evesReceiptFileParser.getOppAccNo();
        JSONObject jsonObject = new JSONObject();
        if (receiptParamsMap.containsKey(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[1])) {
            jsonObject.put(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[1], (Object)oppAccNo);
        }
        if (receiptParamsMap.containsKey(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[3])) {
            jsonObject.put(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[3], (Object)amount);
        }
        if (receiptParamsMap.containsKey(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[4])) {
            jsonObject.put(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[4], (Object)cdFlag);
        }
        if (receiptParamsMap.containsKey(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[5])) {
            jsonObject.put(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[5], (Object)receiptNo);
        }
        return jsonObject.toJSONString();
    }
}

