/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.eves.dc.receipt.fetch;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.eves.dc.receipt.api.ReceiptQueryImpl;
import kd.ebg.receipt.banks.eves.dc.receipt.config.EvesBankBusinessProperties;
import kd.ebg.receipt.banks.eves.dc.receipt.helper.Packer;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.ReceiptInfo;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class EvesReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(EvesReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "RECEIPT_FETCHLIST";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(1);
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        EvesBankBusinessProperties bankBusinessProperties = (EvesBankBusinessProperties)EBConfigBuilder.getInstance().buildConfig(EvesBankBusinessProperties.class);
        Packer.buildCurrentRunningParam(bankBusinessProperties);
        String bankCurrency = Packer.getBankCurrency(accNo);
        ReceiptQueryImpl receiptQuery = new ReceiptQueryImpl();
        List<ReceiptInfo> details = receiptQuery.queryReceiptList(accNo, transDate, bankCurrency);
        if (details.isEmpty()) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u6ca1\u6709\u56de\u5355\u8bb0\u5f55", (String)"ReceiptFetchListImpl_0", (String)"ebg-receipt-banks-eves-dc", (Object[])new Object[0]));
        }
        for (ReceiptInfo detail : details) {
            String amount = detail.getAmount();
            String oppAccNo = detail.getOppAccNo();
            String vouNo = detail.getReceiptNo();
            String vouDate = detail.getTransDate();
            String businessCod = detail.getTranSerialNo();
            String cdFlag = detail.getExplanation();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("amount", (Object)amount);
            jsonObject.put("oppAccNo", (Object)oppAccNo);
            jsonObject.put("vouNo", (Object)vouNo);
            jsonObject.put("vouDate", (Object)vouDate);
            jsonObject.put("businessCod", (Object)businessCod);
            jsonObject.put("cdFlag", (Object)cdFlag);
            StringBuilder fileName = new StringBuilder();
            fileName.append(accNo).append("_");
            fileName.append(transDateStr).append("_");
            fileName.append(businessCod).append("_");
            fileName.append(oppAccNo).append("_");
            fileName.append(amount).append("_");
            fileName.append(cdFlag).append("_");
            fileName.append(vouNo).append(".ofd");
            DownloadListDetail downloadListDetail = new DownloadListDetail();
            downloadListDetail.setFileName(fileName.toString());
            downloadListDetail.setFileLink(jsonObject.toJSONString());
            result.add(downloadListDetail);
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u6ca1\u6709\u56de\u5355\u8bb0\u5f55", (String)"EvesReceiptFetchListImpl_0", (String)"ebg-receipt-banks-eves-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }
}

