/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.eves.dc.receipt.helper;

import java.security.PrivateKey;
import java.security.PublicKey;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.banks.eves.dc.receipt.helper.GmUtil;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.model.CertInfo;
import kd.ebg.receipt.common.model.repository.UserCertRepository;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import org.apache.commons.codec.binary.Base64;

public class EvesKeyStoreUtil {
    public static PublicKey getPublicPK() {
        UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID("public_pk", "business_eves", RequestContextUtils.getRequestContext().getCustomID());
        if (certInfo == null) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u83b7\u53d6\u5ba2\u6237\u7aef\u516c\u94a5\u5931\u8d25\uff0c\u8bf7\u5148\u5230\u56de\u5355\u53c2\u6570\u914d\u7f6e\u9875\u9762\u914d\u7f6e\u3002", (String)"EvesKeyStoreUtil_0", (String)"ebg-receipt-banks-eves-dc", (Object[])new Object[0]));
        }
        CipherInfo cipherInfo = EvesKeyStoreUtil.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        String publicKeyStr = EvesKeyStoreUtil.getKey(fileContent);
        try {
            PublicKey publicKey = GmUtil.fileToCertificate(publicKeyStr.getBytes());
            return publicKey;
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u516c\u94a5\u8bc1\u4e66\u5931\u8d25\u3002", (String)"EvesKeyStoreUtil_3", (String)"ebg-receipt-banks-eves-dc", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public static PrivateKey getPrivateCertFile() {
        UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID("private_cert", "business_eves", RequestContextUtils.getRequestContext().getCustomID());
        if (certInfo == null) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u83b7\u53d6\u5ba2\u6237\u7aef\u79c1\u94a5\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u5148\u5230\u56de\u5355\u53c2\u6570\u914d\u7f6e\u9875\u9762\u914d\u7f6e\u3002", (String)"EvesKeyStoreUtil_1", (String)"ebg-receipt-banks-eves-dc", (Object[])new Object[0]));
        }
        CipherInfo cipherInfo = EvesKeyStoreUtil.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        String privateKeyStr = EvesKeyStoreUtil.getKey(fileContent);
        privateKeyStr = privateKeyStr.replaceAll("-----BEGIN PRIVATE KEY-----", "");
        privateKeyStr = privateKeyStr.replaceAll("-----END PRIVATE KEY-----", "");
        privateKeyStr = privateKeyStr.replaceAll("\r", "");
        privateKeyStr = privateKeyStr.replaceAll("\n", "");
        try {
            PrivateKey privateKeyFromD = GmUtil.privateKeyFromBytes(java.util.Base64.getDecoder().decode(privateKeyStr));
            return privateKeyFromD;
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u7528\u6237\u79c1\u94a5\u5931\u8d25\u3002", (String)"EvesKeyStoreUtil_2", (String)"ebg-receipt-banks-eves-dc", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private static CipherInfo getCipherInfo(String data) {
        AESCipherSecurity security = (AESCipherSecurity)SpringContextUtil.getBean(AESCipherSecurity.class);
        CipherInfo cipherInfo = security.getCipherInfo(data);
        if (cipherInfo.getCipherVersion() == 0) {
            cipherInfo.setFileBytes(java.util.Base64.getDecoder().decode(cipherInfo.getCipherData()));
        } else {
            cipherInfo.setFileBytes(Base64.decodeBase64((String)cipherInfo.getCipherData()));
        }
        return cipherInfo;
    }

    private static String getKey(byte[] fileContent) {
        return StringUtils.byteToString((byte[])fileContent);
    }
}

