/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.eves.dc.receipt.helper;

import java.time.LocalDate;
import java.time.LocalDateTime;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.eves.dc.receipt.config.EvesBankBusinessProperties;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.utils.CurrencyUtils;
import org.jdom2.Element;

public class Packer {
    public static Element createHead(String tr_code) {
        Element root = JDomUtils.createRoot((String)"root");
        Element head = JDomUtils.addChild((Element)root, (String)"head");
        String localDateTimeStr = LocalDateUtil.formatDate((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmmss");
        String reqSeqNo = localDateTimeStr + Sequence.gen16NumSequence();
        JDomUtils.addChild((Element)head, (String)"SrcCode", (String)RequestContextUtils.getRunningParam((String)"src_code"));
        JDomUtils.addChild((Element)head, (String)"DesCode", (String)RequestContextUtils.getRunningParam((String)"des_code"));
        JDomUtils.addChild((Element)head, (String)"TranCode", (String)tr_code);
        JDomUtils.addChild((Element)head, (String)"ReqTime", (String)localDateTimeStr);
        JDomUtils.addChild((Element)head, (String)"ReqSeqNo", (String)(reqSeqNo + "00"));
        JDomUtils.addChild((Element)head, (String)"SigCerNo", (String)RequestContextUtils.getRunningParam((String)"sig_cer_no"));
        return root;
    }

    public static String packCommonWithSign(String xmlStr, String signStr) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(xmlStr);
        buffer.append("\n");
        buffer.append("{sign:");
        buffer.append(signStr);
        buffer.append("}");
        return buffer.toString();
    }

    public static String rootToString(Element root) {
        String charset = RequestContextUtils.getRunningParam((String)"eves_charset");
        return JDomUtils.root2String((Element)root, (String)charset);
    }

    public static void buildCurrentRunningParam(EvesBankBusinessProperties config) {
        RequestContextUtils.setRunningParam((String)"eves_charset", (String)config.getCharset());
        RequestContextUtils.setRunningParam((String)"des_code", (String)config.getDesCode());
        RequestContextUtils.setRunningParam((String)"sig_cer_no", (String)config.getSigCerNo());
        RequestContextUtils.setRunningParam((String)"src_code", (String)config.getSrcCode());
        RequestContextUtils.setRunningParam((String)"request_code", (String)config.getRequestCode());
        RequestContextUtils.setRunningParam((String)"receive_code", (String)config.getReceiveCode());
        RequestContextUtils.setRunningParam((String)"receipt_ip", (String)config.getReceiptIp());
        RequestContextUtils.setRunningParam((String)"receipt_port", (String)config.getReceiptPort());
        RequestContextUtils.setRunningParam((String)"receipt_protocol", (String)config.getReceiptProtocol());
        RequestContextUtils.setRunningParam((String)"receipt_uri", (String)config.getReceiptUri());
    }

    public static String getBankCurrency(String accNo) {
        BankAcnt mainAcnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(accNo, EBContext.getContext().getCustomID());
        String currency = mainAcnt.getCurrency();
        String bankCurrency = CurrencyUtils.convert2Bank((String)currency);
        return bankCurrency;
    }

    public static Element packT2003(BankReceiptRequest request, String currency, String currentPageNo) {
        Element root = Packer.createHead("T2003");
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        String transDateStr = LocalDateUtil.formatDate((LocalDate)request.getTransDate());
        JDomUtils.addChild((Element)body, (String)"RequestCode", (String)RequestContextUtils.getRunningParam((String)"request_code"));
        JDomUtils.addChild((Element)body, (String)"ReceiveCode", (String)RequestContextUtils.getRunningParam((String)"receive_code"));
        JDomUtils.addChild((Element)body, (String)"AccNo", (String)request.getAccNo());
        JDomUtils.addChild((Element)body, (String)"CurrCod", (String)currency);
        JDomUtils.addChild((Element)body, (String)"StartDate", (String)transDateStr);
        JDomUtils.addChild((Element)body, (String)"EndDate", (String)transDateStr);
        JDomUtils.addChild((Element)body, (String)"PageSize", (String)"30");
        JDomUtils.addChild((Element)body, (String)"PageNo", (String)currentPageNo);
        return root;
    }

    public static Element packT1001(BankReceiptRequest request, String currency, String vouNo, String vouDate) {
        Element root = Packer.createHead("T1001");
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"RequestCode", (String)RequestContextUtils.getRunningParam((String)"request_code"));
        JDomUtils.addChild((Element)body, (String)"ReceiveCode", (String)RequestContextUtils.getRunningParam((String)"receive_code"));
        JDomUtils.addChild((Element)body, (String)"AccNo", (String)request.getAccNo());
        JDomUtils.addChild((Element)body, (String)"CurrCod", (String)currency);
        JDomUtils.addChild((Element)body, (String)"VouNo", (String)vouNo);
        JDomUtils.addChild((Element)body, (String)"VouDate", (String)vouDate);
        return root;
    }

    public static Element packT1002(BankReceiptRequest request, String currency) {
        Element root = Packer.createHead("T1002");
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        String accDate = LocalDateUtil.formatDate((LocalDate)request.getTransDate());
        JDomUtils.addChild((Element)body, (String)"RequestCode", (String)RequestContextUtils.getRunningParam((String)"request_code"));
        JDomUtils.addChild((Element)body, (String)"ReceiveCode", (String)RequestContextUtils.getRunningParam((String)"receive_code"));
        JDomUtils.addChild((Element)body, (String)"AccNo", (String)request.getAccNo());
        JDomUtils.addChild((Element)body, (String)"CurrCod", (String)currency);
        JDomUtils.addChild((Element)body, (String)"AccDate", (String)accDate.substring(0, 6));
        return root;
    }

    public static Element packT1003(BankReceiptRequest request, String elcVouFile) {
        Element root = Packer.createHead("T1003");
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        String accDate = LocalDateUtil.formatDate((LocalDate)request.getTransDate());
        JDomUtils.addChild((Element)body, (String)"RequestCode", (String)RequestContextUtils.getRunningParam((String)"request_code"));
        JDomUtils.addChild((Element)body, (String)"ReceiveCode", (String)RequestContextUtils.getRunningParam((String)"receive_code"));
        JDomUtils.addChild((Element)body, (String)"AccNo", (String)request.getAccNo());
        JDomUtils.addChild((Element)body, (String)"AccDate", (String)accDate.substring(0, 6));
        JDomUtils.addChild((Element)body, (String)"ElcVouFile", (String)elcVouFile);
        return root;
    }
}

