/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.eves.dc.receipt.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.business.receipt.bank.ReceiptInfo;
import org.jdom2.Element;

public class Parser {
    public static Element stringToElement(String responseStr) {
        String charset = RequestContextUtils.getRunningParam((String)"eves_charset");
        return JDomUtils.string2Root((String)responseStr, (String)charset);
    }

    public static BankResponse parserHead(Element root) {
        BankResponse response = new BankResponse();
        Element head = root.getChild("head");
        String rspCode = head.getChildTextTrim("RspCode");
        String ret_msg = head.getChildTextTrim("rspMsg");
        if (!"00000000".equals(rspCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff0c\u62a5\u6587\u8fd4\u56de\u72b6\u6001\uff1a%1$s,\u94f6\u884c\u8fd4\u56de\u4fe1\u606f\uff1a%2$s", (String)"Parser_2", (String)"ebg-receipt-banks-eves-dc", (Object[])new Object[0]), rspCode, ret_msg));
        }
        response.setResponseCode(rspCode);
        if (!StringUtils.isEmpty((String)ret_msg)) {
            response.setResponseMessage(ret_msg);
        }
        return response;
    }

    public static List<ReceiptInfo> parseT2003(Element root) {
        Element body = root.getChild("body");
        String total = body.getChildTextTrim("Total");
        String currentPage = Parser.getCurrentPage();
        if (StringUtils.isEmpty((String)total) || Integer.parseInt(total) > (Integer.parseInt(currentPage) + 1) * Integer.parseInt("30")) {
            Parser.setLastPage(true);
        } else {
            Parser.setLastPage(false);
        }
        Element receiptList = body.getChild("ReceiptList");
        List receiptEle = receiptList.getChildren();
        ArrayList<ReceiptInfo> receiptInfos = new ArrayList<ReceiptInfo>(1);
        if (!receiptEle.isEmpty()) {
            for (Element element : receiptEle) {
                String vouNo = element.getChildTextTrim("VouNo");
                String vouDate = element.getChildTextTrim("VouDate");
                String accNo = element.getChildTextTrim("AccNo");
                String businessCod = element.getChildTextTrim("BusinCod");
                String payAccNo = element.getChildTextTrim("PayAccNo");
                String collAccNo = element.getChildTextTrim("CollAccNo");
                String businessAmount = element.getChildTextTrim("BusinAmount");
                String cdFlag = "C";
                String oppAccNo = collAccNo;
                if (Objects.equals(accNo, payAccNo)) {
                    cdFlag = "C";
                    oppAccNo = collAccNo;
                }
                if (Objects.equals(accNo, collAccNo)) {
                    cdFlag = "D";
                    oppAccNo = payAccNo;
                }
                ReceiptInfo receiptInfo = new ReceiptInfo();
                receiptInfo.setAmount(businessAmount);
                receiptInfo.setOppAccNo(oppAccNo);
                receiptInfo.setReceiptNo(vouNo);
                receiptInfo.setTransDate(vouDate);
                receiptInfo.setTranSerialNo(businessCod);
                receiptInfo.setExplanation(cdFlag);
                receiptInfos.add(receiptInfo);
            }
        }
        return receiptInfos;
    }

    public static String parseT1001(Element root) {
        Element body = root.getChild("body");
        String elcVouFile = body.getChildTextTrim("ElcVouFile");
        return elcVouFile;
    }

    public static String parseT1002(Element root) {
        Element body = root.getChild("body");
        String elcVouFile = body.getChildTextTrim("ElcVouFile");
        return elcVouFile;
    }

    protected static String getCurrentPage() {
        return RequestContextUtils.getRunningParam((String)"pageKey");
    }

    protected static void setLastPage(boolean lastPage) {
        RequestContextUtils.setRunningParam((String)"lastPageKey", (String)String.valueOf(lastPage));
    }

    public static String parseSignStr(String xmlStr) {
        if (StringUtils.isEmpty((String)xmlStr)) {
            return null;
        }
        String signStr = xmlStr.substring(xmlStr.indexOf("{sign"));
        String signBodyStr = signStr.split(":")[1];
        signBodyStr = signBodyStr.replace("}", "");
        return signBodyStr;
    }

    public static String parseXmlOutSign(String xmlStr) {
        if (StringUtils.isEmpty((String)xmlStr)) {
            return null;
        }
        String bodyStr = xmlStr.substring(0, xmlStr.indexOf("{sign"));
        return bodyStr;
    }
}

