/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bcs.dc.service.receipt;

import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.core.utils.ErrorMsgUtil;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoJsonService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public EBCReceiptInfoJsonService receiptInfoJsonService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.receiptInfoJsonService = (EBCReceiptInfoJsonService)SpringContextUtil.getBean(EBCReceiptInfoJsonService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        ChannelSftp sftp = null;
        String bankLogin = request.getBankLoginId();
        String bankVersionId = request.getBankVersionId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp") && SFTPUtils.getInstance().isAbort(sftp)) {
            sftp = SFTPUtils.getInstance().getSftp(bankLogin);
        }
        boolean isLastFile = false;
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(downloadListDetails.size());
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        for (int i = 0; i < downloadListDetails.size(); ++i) {
            if (i == downloadListDetails.size() - 1) {
                isLastFile = true;
            }
            DownloadListDetail downloadListDetail = (DownloadListDetail)downloadListDetails.get(i);
            DownloadListDetail detail = this.download(downloadListDetail, bakFilePath, bankLogin, isLastFile, bankFtpProperties, sftp);
            result.add(detail);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public DownloadListDetail download(DownloadListDetail detail, String bakFilePath, String bankLogin, boolean isLastFile, BankFtpProperties bankFtpProperties, ChannelSftp sftp) {
        block15: {
            boolean result = true;
            String ftpPath = "/";
            String accNo = detail.getAccNo();
            LocalDate transDate = detail.getTransDate();
            try {
                File receiptFile = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + detail.getFileName()));
                if (receiptFile.exists()) {
                    DownloadListDetail downloadListDetail = detail;
                    return downloadListDetail;
                }
                if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                    if (SFTPUtils.getInstance().isAbort(sftp)) {
                        sftp = SFTPUtils.getInstance().getSftp(bankLogin);
                    }
                    if (StringUtils.isNotEmpty((String)bankFtpProperties.getFtpPath())) {
                        ftpPath = bankFtpProperties.getFtpPath();
                    }
                    result = SFTPUtils.getInstance().downloadSingleFile(ftpPath, detail.getFileLink(), bakFilePath, sftp);
                } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
                    BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
                    result = bankReceiptApiUtil.downloadReceiptFile(detail.getFileLink(), bakFilePath);
                }
                if (!result) {
                    throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25:%s", (String)"BankReceiptDownloadImpl_3", (String)"ebg-receipt-banks-bcs-dc", (Object[])new Object[0]), detail.getFileLink()));
                }
                File file = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + detail.getFileLink()));
                if (file.exists()) {
                    FileCommonUtils.moveFile((File)file, (String)bakFilePath, (String)detail.getFileName());
                    break block15;
                }
                throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u56de\u5355\u6587\u4ef6\u4e0d\u5b58\u5728:%s", (String)"BankReceiptDownloadImpl_4", (String)"ebg-receipt-banks-bcs-dc", (Object[])new Object[0]), detail.getFileLink()));
            }
            catch (Exception e) {
                String msg = ErrorMsgUtil.getSFTPErrorMSG((String)detail.getFileLink(), (String)e.getMessage());
                throw new ReceiptException(msg, (Throwable)e);
            }
            finally {
                if (isLastFile) {
                    SFTPUtils.getInstance().close(sftp);
                }
            }
        }
        return detail;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "BCS_DC_BankReceiptDownload";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u957f\u6c99\u94f6\u884c\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d", (String)"BankReceiptDownloadImpl_2", (String)"ebg-receipt-banks-bcs-dc", (Object[])new Object[0]);
    }
}

