/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bcs.dc.service.receipt.api;

import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.banks.bcs.dc.service.util.RequestPacker;
import kd.ebg.receipt.banks.bcs.dc.service.util.ResponseParser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;

public class BcsDcReceiptDownloadRequest
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BcsDcReceiptDownloadRequest.class);

    public String pack(BankReceiptRequest bankDetailRequest) {
        String accNo = bankDetailRequest.getAccNo();
        String transDate = bankDetailRequest.getTransDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String host_serial_no = bankDetailRequest.getRequestStr();
        String receiptRequest = RequestPacker.receiptRequest(accNo, transDate, host_serial_no);
        logger.info("\u957f\u6c99\u94f6\u884c\u2014\u2014\u56de\u5355\u4e0b\u8f7d\u8bf7\u6c42-{}-{}\uff1a{}", new Object[]{accNo, transDate, receiptRequest});
        return receiptRequest;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        String accNo = request.getAccNo();
        String transDate = request.getTransDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        logger.info("\u957f\u6c99\u94f6\u884c\u2014\u2014\u56de\u5355\u4e0b\u8f7d\u54cd\u5e94-{}-{}\uff1a{}", new Object[]{accNo, transDate, responseStr});
        responseStr = BcsDcReceiptDownloadRequest.parseRecvMsg(responseStr);
        String reportFileName = ResponseParser.receiptResponseParse(responseStr);
        return BankReceiptResponseEB.success((Object)reportFileName);
    }

    public static String parseRecvMsg(String input) {
        String flag = "<ap>";
        if (!StringUtils.isEmpty((String)input)) {
            int index = input.indexOf(flag);
            return input.substring(index);
        }
        return "";
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "200110";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", (String)"BcsDcReceiptDownloadRequest_0", (String)"ebg-receipt-banks-bcs-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
    }
}

