/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bosh.dc.service.api.login;

import java.io.OutputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.receipt.banks.bosh.dc.service.api.login.LoginAndOutPacker;
import kd.ebg.receipt.banks.bosh.dc.service.api.login.LoginAndOutParser;
import kd.ebg.receipt.banks.bosh.dc.service.api.sign.SignHelper;
import kd.ebg.receipt.banks.bosh.dc.service.api.utils.BOSH_URLEncode;
import kd.ebg.receipt.banks.bosh.dc.service.api.utils.CommumicationHelper;
import kd.ebg.receipt.banks.bosh.dc.service.api.utils.Parser;
import kd.ebg.receipt.common.framework.frame.EBGLogger;

public class LoginAndOut {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(LoginAndOut.class);

    public static String login4GetSession() throws Exception {
        String sequence = Sequence.gen18Sequence();
        String loginMsg = LoginAndOutPacker.packLoginMsg(sequence);
        String signedLoginMsg = SignHelper.sign(loginMsg);
        String reqData = BOSH_URLEncode.encode(signedLoginMsg);
        StringBuilder buffer = new StringBuilder();
        buffer.append("opName").append("=").append("CebankUserLogon1_1Op").append("&").append("reqData").append("=").append(reqData);
        String recvMsg = LoginAndOut.sendAndRecvMsg4Login(buffer.toString());
        String session = LoginAndOutParser.parseLogonSessionID(recvMsg);
        recvMsg = recvMsg.substring(41);
        BankResponse rsp = Parser.parseResponse(recvMsg);
        if (!"0".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u767b\u5f55\u4ea4\u6613\u5931\u8d25\uff0c\u94f6\u884c\u54cd\u5e94:%s\u3002", (String)"LoginAndOut_1", (String)"ebg-receipt-banks-bosh-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        return session;
    }

    public static void logout(String session) {
        logger.info("\u7b7e\u9000\u4ea4\u6613\u5f00\u59cb");
        StringBuilder buffer = new StringBuilder();
        buffer.append("dse_sessionId").append("=").append(session);
        String recvMsg = LoginAndOut.sendAndRecvMsg4Logout(buffer.toString());
        logger.info("\u7b7e\u9000\u4ea4\u6613\u7ed3\u675f");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String sendAndRecvMsg4Login(String msg) {
        try {
            ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
            factory.setUri("/CM/APISessionReqServlet?" + msg);
            factory.setHttpHeader("User-Agent", "MSIE");
            IConnection conn = factory.createExchangeConnection();
            conn.openConnection();
            try (OutputStream outputStream = conn.getOutputStream();){
                String string = CommumicationHelper.sendAndRecvMessage(conn, outputStream, msg);
                return string;
            }
        }
        catch (Throwable t) {
            throw EBExceiptionUtil.serviceException((Throwable)t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String sendAndRecvMsg4Logout(String msg) {
        try {
            ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
            factory.setUri("/CM/APISignOffReqServlet");
            factory.setHttpHeader("User-Agent", "MSIE");
            IConnection conn = factory.createExchangeConnection();
            conn.openConnection();
            try (OutputStream outputStream = conn.getOutputStream();){
                String string = CommumicationHelper.sendAndRecvMessage(conn, outputStream, msg);
                return string;
            }
        }
        catch (Throwable t) {
            throw EBExceiptionUtil.serviceException((Throwable)t);
        }
    }
}

