/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.gdb.dc.service.receipt;

import com.jcraft.jsch.ChannelSftp;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.banks.gdb.dc.service.receipt.api.DetailImpl;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        ArrayList<DownloadListDetail> result;
        block51: {
            long taskId = request.getTaskId();
            String accNo = request.getAccNo();
            LocalDate transDate = request.getTransDate();
            String transDateStr = LocalDateUtil.formatDate((LocalDate)request.getTransDate());
            result = new ArrayList<DownloadListDetail>(16);
            if (transDate.isEqual(LocalDate.now())) {
                BankDetailRequest req = BankReceiptFetchListImpl.getDetailList(accNo, transDate);
                EBBankDetailResponse response = new DetailImpl().doBiz(req);
                List details = response.getDetails();
                for (DetailInfo detail : details) {
                    DownloadListDetail downloadListDetail = new DownloadListDetail();
                    String uniqueSeq = detail.getUniqueSeq();
                    String serialNo = detail.getPayBankDetailSeqID();
                    String fileName = accNo + "_" + transDateStr + "_" + serialNo + ".pdf";
                    downloadListDetail.setFileLink(uniqueSeq);
                    downloadListDetail.setFileName(fileName);
                    result.add(downloadListDetail);
                }
                return BankReceiptHandleResponseEB.success(result);
            }
            ChannelSftp sftp = null;
            String downloadFile = accNo + ".txt";
            String date = transDate.toString().replaceAll("-", "");
            String ftpPath = "/" + accNo + "/" + date;
            String bankLogin = request.getBankLoginId();
            String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"GDB_DC", (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
            boolean flag = false;
            BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
            if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                if (SFTPUtils.getInstance().isAbort(sftp)) {
                    sftp = SFTPUtils.getInstance().getSftp(bankLogin);
                }
                String sftpPath = StringUtils.isEmpty((String)bankFtpProperties.getFtpPath()) ? ftpPath : bankFtpProperties.getFtpPath() + ftpPath;
                flag = SFTPUtils.getInstance().downloadSingleFile(sftpPath, downloadFile, bakFilePath, sftp);
            } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
                BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
                String frontProxyPath = bankFtpProperties.getFrontProxyPath() + ftpPath;
                flag = bankReceiptApiUtil.downloadReceiptFileWithPath(frontProxyPath, downloadFile, bakFilePath);
            }
            if (flag) {
                boolean isExist = false;
                File downloadTotalFile = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + downloadFile));
                if (!downloadTotalFile.exists()) {
                    throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u6c47\u603b\u6587\u4ef6\uff1a{%s}\u4e0d\u5b58\u5728\u3002", (String)"BankReceiptFetchListImpl_8", (String)"ebg-receipt-banks-gdb-dc", (Object[])new Object[0]), downloadFile));
                }
                try (FileInputStream fis = new FileInputStream(downloadTotalFile);
                     InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                     BufferedReader br = new BufferedReader(isr);){
                    String line = "";
                    while ((line = br.readLine()) != null) {
                        String[] strArr = line.split("\\|");
                        if (null == strArr || strArr.length <= 0 || !accNo.equals(strArr[0])) continue;
                        isExist = true;
                        DownloadListDetail detail = new DownloadListDetail();
                        String fileName = accNo + "_" + transDateStr + "_" + strArr[1] + ".pdf";
                        detail.setFileName(fileName);
                        detail.setTransDate(transDate);
                        detail.setFileLink(strArr[1] + ".pdf");
                        detail.setBankFilePath(bakFilePath + File.separator + detail.getFileName());
                        result.add(detail);
                    }
                    if (!isExist) {
                        throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u4e0d\u5b58\u5728\u5f53\u524d\u8d26\u53f7[%s]\u7684\u56de\u5355\u6587\u4ef6", (String)"BankReceiptFetchListImpl_9", (String)"ebg-receipt-banks-gdb-dc", (Object[])new Object[0]), accNo));
                    }
                    boolean isDelete = downloadTotalFile.delete();
                    logger.info("\u6587\u4ef6\u540d\uff1a{}-\u5220\u9664\u2014{}", new Object[]{downloadTotalFile.getName(), isDelete});
                    if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                        SFTPUtils.getInstance().close(sftp);
                    }
                    break block51;
                }
                catch (Exception e) {
                    if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                        SFTPUtils.getInstance().close(sftp);
                    }
                    logger.info("\u6267\u884c\u83b7\u53d6\u89e3\u6790\u56de\u5355\u6982\u8981\u6587\u4ef6\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38\u3002{}", (Object)e.getMessage());
                    throw new ReceiptException(ResManager.loadKDString((String)"\u6267\u884c\u83b7\u53d6\u89e3\u6790\u56de\u5355\u6982\u8981\u6587\u4ef6\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38\u3002", (String)"BankReceiptFetchListImpl_3", (String)"ebg-receipt-banks-gdb-dc", (Object[])new Object[0]), (Throwable)e);
                }
            }
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u8d26\u53f7[%s]\u7684\u94f6\u884c\u56de\u5355\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u94f6\u884c\u662f\u5426\u5df2\u63a8\u9001\u8be5\u8d26\u53f7\u7684\u56de\u5355\u6587\u4ef6\u3002", (String)"BankReceiptFetchListImpl_10", (String)"ebg-receipt-banks-gdb-dc", (Object[])new Object[0]), accNo));
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_6", (String)"ebg-receipt-banks-gdb-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "GDB_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u5e7f\u53d1\u94f6\u884c\u76f4\u8054\u7248\u56de\u5355\u6587\u4ef6\u5217\u8868\u3002", (String)"BankReceiptFetchListImpl_7", (String)"ebg-receipt-banks-gdb-dc", (Object[])new Object[0]);
    }

    public static BankDetailRequest getDetailList(String accNo, LocalDate transDate) {
        BankDetailRequest request = new BankDetailRequest();
        BankHeader header = new BankHeader();
        BankAcnt acnt = new BankAcnt();
        acnt.setAccNo(accNo);
        header.setAcnt(acnt);
        request.setHeader(header);
        request.setStartDate(transDate);
        request.setEndDate(transDate);
        return request;
    }
}

