/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.gdb.dc.service.receipt.api;

import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.gdb.dc.service.receipt.Packer;
import kd.ebg.receipt.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.receipt.business.detail.atomic.IDetail;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public String pack(BankDetailRequest request) {
        Element root = Packer.createRootNode();
        Element message = Packer.createMessageNode(root, "0024", Packer.getSeqNo());
        Element body = JDomUtils.addChild((Element)message, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"account", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"beginDate", (String)request.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)body, (String)"endDate", (String)request.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)body, (String)"queryType", (String)"0");
        return JDomUtils.root2String((Element)root, (String)"GBK");
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        ArrayList<DetailInfo> result = new ArrayList<DetailInfo>(1);
        Element root = JDomUtils.string2Root((String)responseStr, (String)"GBK");
        Element message = JDomUtils.getUnNullChildElement((Element)root, (String)"Message");
        Element commHead = JDomUtils.getUnNullChildElement((Element)message, (String)"commHead");
        String retCode = JDomUtils.getUnNullChildTextTrim((Element)commHead, (String)"retCode");
        Element body = JDomUtils.getUnNullChildElement((Element)message, (String)"Body");
        log.info("retCode:" + retCode);
        if ("000".equalsIgnoreCase(retCode)) {
            Element records = JDomUtils.getUnNullChildElement((Element)body, (String)"records");
            if (records == null) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u6ca1\u6709\u8fd4\u56de\u8bb0\u5f55", (String)"DetailImpl_0", (String)"ebg-receipt-banks-gdb-dc", (Object[])new Object[0]));
            }
            List recordList = records.getChildren("record");
            if (recordList != null && !recordList.isEmpty()) {
                for (Element e : recordList) {
                    DetailInfo detailInfo = new DetailInfo();
                    String reserve2 = e.getChildTextTrim("reserve2");
                    String serialNo = e.getChildTextTrim("serialNo");
                    detailInfo.setUniqueSeq(reserve2);
                    detailInfo.setPayBankDetailSeqID(serialNo);
                    result.add(detailInfo);
                }
            }
        } else if ("242".equalsIgnoreCase(retCode) || "251".equalsIgnoreCase(retCode)) {
            log.info("\u8fd4\u56de\u54cd\u5e94\u7801{},\u65e0\u7b26\u5408\u6761\u4ef6\u7684\u4ea4\u6613\u8bb0\u5f55", (Object)retCode);
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672c\u6b21\u67e5\u8be2\u8fd4\u56de\u4e86\u975e\u6b63\u5e38\u7684\u8fd4\u56de\u7801:%s\u3002", (String)"DetailImpl_3", (String)"ebg-receipt-banks-gdb-dc", (Object[])new Object[0]), retCode));
        }
        return new EBBankDetailResponse(result);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "0024";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6307\u5b9a\u65e5\u671f\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_2", (String)"ebg-receipt-banks-gdb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }
}

