/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ynhtb.dc.service.receipt;

import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoJsonService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(kd.ebg.receipt.banks.xmb.dc.service.receipt.BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public EBCReceiptInfoJsonService receiptInfoJsonService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.receiptInfoJsonService = (EBCReceiptInfoJsonService)SpringContextUtil.getBean(EBCReceiptInfoJsonService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String bankLogin = request.getBankLoginId();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate, (String)"yyyyMMdd");
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"YNHTB_DC", (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        boolean isLastFile = false;
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        for (int i = 0; i < downloadListDetails.size(); ++i) {
            boolean flag;
            DownloadListDetail detail = (DownloadListDetail)downloadListDetails.get(i);
            if (i == downloadListDetails.size() - 1) {
                isLastFile = true;
            }
            if (!(flag = this.download(detail, bakFilePath, bankLogin, isLastFile))) continue;
            result.add(detail);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public boolean download(DownloadListDetail detail, String destFolder, String bankLogin, boolean isLastFile) {
        boolean result = true;
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
        String ftpPath = bankFtpProperties.getFtpPath();
        String string = ftpPath = EBGStringUtils.isEmpty((String)ftpPath) ? "/" : ftpPath;
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
            ChannelSftp sftp = null;
            if (SFTPUtils.getInstance().isAbort(sftp)) {
                sftp = SFTPUtils.getInstance().getSftp(bankLogin);
            }
            result = SFTPUtils.getInstance().downloadSingleFile(ftpPath, detail.getFileLink(), destFolder, sftp);
            File file = FileCommonUtils.getFileByPath((String)(destFolder + File.separator + detail.getFileLink()));
            if (file.exists()) {
                FileCommonUtils.moveFile((File)file, (String)destFolder, (String)detail.getFileName());
            } else {
                result = false;
            }
            if (isLastFile) {
                SFTPUtils.getInstance().close(sftp);
            }
        } else {
            throw new ReceiptException(ResManager.loadKDString((String)"\u7ea2\u5854\u94f6\u884c\u4ec5\u652f\u6301\u901a\u8fc7sftp\u7684\u65b9\u5f0f\u83b7\u53d6\u6587\u4ef6\uff0c\u8bf7\u5728[\u914d\u7f6e\u9879]-[\u94f6\u884c\u914d\u7f6e]-[\u56de\u5355\u83b7\u53d6\u65b9\u5f0f]\u9009\u62e9\"\u8fdc\u7a0bsftp\u83b7\u53d6\"\u3002", (String)"BankReceiptDownloadImpl_0", (String)"ebg-receipt-banks-ynhtb-dc", (Object[])new Object[0]));
        }
        return result;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }
}

