/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ynhtb.dc.service.receipt;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.receipt.banks.ynhtb.dc.service.receipt.YNHTBDCCommConfig;
import kd.ebg.receipt.banks.ynhtb.dc.service.receipt.api.YnthbBankReceiptDwonloadRequestImpl;
import kd.ebg.receipt.banks.ynhtb.dc.service.receipt.api.YnthbBankReceiptNameRequestImpl;
import kd.ebg.receipt.banks.ynhtb.dc.service.receipt.utils.RequestPacker;
import kd.ebg.receipt.banks.ynhtb.dc.service.receipt.utils.ResponseParser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankLoginProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(kd.ebg.receipt.banks.xmb.dc.service.receipt.BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest bankReceiptHandleRequest) {
        this.init(bankReceiptHandleRequest);
        long taskId = bankReceiptHandleRequest.getTaskId();
        DownloadListTask task = this.downloadTaskService.findById(taskId);
        ArrayList<DownloadListDetail> detailList = new ArrayList<DownloadListDetail>(16);
        String accNo = task.getAccNo();
        LocalDate transDate = task.getTransDate();
        String transDateStr = task.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        String bankLoginID = EBContext.getContext().getBankLoginID();
        DownloadListDetail detail = null;
        BankLoginProperties loginProperties = (BankLoginProperties)EBConfigBuilder.getInstance().buildConfig(BankLoginProperties.class, bankLoginID);
        String host = loginProperties.getIp();
        int port = loginProperties.getPort();
        YNHTBDCCommConfig config = (YNHTBDCCommConfig)EBConfigBuilder.getInstance().buildConfig(YNHTBDCCommConfig.class, task.getBankLoginId());
        String corpId = config.getCorpId();
        String request = RequestPacker.getSelDetailRequestXml(corpId, accNo, transDate, transDate);
        logger.info("\u7ea2\u5854\u94f6\u884c\u67e5\u8be2\u660e\u7ec6\u6587\u4ef6\u540d\u8bf7\u6c42\u62a5\u6587\uff1a\n" + request);
        YnthbBankReceiptNameRequestImpl ynthbBankDetailRequest = new YnthbBankReceiptNameRequestImpl();
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().requestStr(request).accNo(accNo).transDate(transDate).build();
        BankReceiptResponseEB ynthbBankDetailResponseEB = (BankReceiptResponseEB)ynthbBankDetailRequest.doBiz((BankRequest)bankReceiptRequest);
        String response = (String)ynthbBankDetailResponseEB.getData();
        logger.info("\u7ea2\u5854\u94f6\u884c\u67e5\u8be2\u660e\u7ec6\u6587\u4ef6\u540d\u8bf7\u54cd\u5e94\u62a5\u6587\uff1a\n" + response);
        Map<String, String> result = ResponseParser.parse(response);
        String totalNum = result.get("TotalNum");
        String fileName = result.get("FileName");
        logger.info("\u7ea2\u5854\u94f6\u884c\u83b7\u53d6\u5230\u660e\u7ec6\u6587\u4ef6\u540d\u6570\u91cf{}\u7b14\uff0c\u6587\u4ef6\u540d\u79f0\uff1a{}", new Object[]{totalNum, fileName});
        if (EBGStringUtils.isEmpty((String)fileName) || EBGStringUtils.isEmpty((String)totalNum) || "0".equals(totalNum)) {
            String dateStr = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u660e\u7ec6\u6587\u4ef6\u540d\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8d26\u53f7%s\u3002", (String)"BankReceiptFetchListImpl_5", (String)"ebg-receipt-banks-ynhtb-dc", (Object[])new Object[0]), accNo) + String.format(ResManager.loadKDString((String)"\u5728%s\u4e0d\u5b58\u5728\u4ea4\u6613", (String)"BankReceiptFetchListImpl_6", (String)"ebg-receipt-banks-ynhtb-dc", (Object[])new Object[0]), dateStr));
        }
        List<DetailInfo> detailInfoList = ResponseParser.fileDownloadAndParse(task, fileName);
        for (DetailInfo detailInfo : detailInfoList) {
            String time = detailInfo.getTransDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            String serial = detailInfo.getExplanation();
            request = RequestPacker.get520005RequestXml(corpId, detailInfo.getAccNo(), time, serial, detailInfo.getKdFlag(), detailInfo.getReversed1());
            logger.info("\u7ea2\u5854\u94f6\u884c\u5355\u7b14\u6536\u4ed8\u56de\u5355\u4e0b\u8f7d(520005)\u8bf7\u6c42\u62a5\u6587\uff1a\n\uff1a", (Object)request);
            YnthbBankReceiptDwonloadRequestImpl YnthbBankReceiptNameRequest = new YnthbBankReceiptDwonloadRequestImpl();
            bankReceiptRequest = BankReceiptRequest.builder().requestStr(request).accNo(accNo).transDate(transDate).build();
            BankReceiptResponseEB ynthbBankReceiptNameResponseEB = (BankReceiptResponseEB)YnthbBankReceiptNameRequest.doBiz((BankRequest)bankReceiptRequest);
            response = (String)ynthbBankReceiptNameResponseEB.getData();
            logger.info("\u7ea2\u5854\u94f6\u884c\u5355\u7b14\u6536\u4ed8\u56de\u5355\u4e0b\u8f7d(520005)\u54cd\u5e94\u62a5\u6587\uff1a\n\uff1a{}", (Object)response);
            Map<String, String> fileResult = ResponseParser.parse(response);
            String receiptFileName = fileResult.get("FileName");
            if (!EBGStringUtils.isEmpty((String)receiptFileName)) {
                String newFileName = accNo + "_" + transDate + "_" + detailInfo.getExplanation() + "_" + detailInfo.getDebitAmount().toPlainString() + "_" + detailInfo.getKdFlag() + "_" + detailInfo.getReversed1() + ".pdf";
                detail = new DownloadListDetail();
                detail.setFileLink(receiptFileName);
                detail.setFileName(newFileName);
                detailList.add(detail);
                continue;
            }
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u7ea2\u5854\u94f6\u884c\u5355\u7b14\u6536\u4ed8\u56de\u5355\u4e0b\u8f7d(520005)\u5931\u8d25\uff0c%1$s-%2$s\u3002", (String)"BankReceiptFetchListImpl_7", (String)"ebg-receipt-banks-ynhtb-dc", (Object[])new Object[0]), detailInfo.getAccNo(), detailInfo.getTransDate()));
        }
        return BankReceiptHandleResponseEB.success(detailList);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u7535\u5b50\u56de\u5355\u6587\u4ef6\u5217\u8868", (String)"BankReceiptFetchListImpl_4", (String)"ebg-receipt-banks-ynhtb-dc", (Object[])new Object[0]);
    }

    public boolean isBreak() {
        return true;
    }
}

