/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ynhtb.dc.service.receipt.utils;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class RequestPacker {
    public static String getSelDetailRequestXml(String corpId, String accNo, LocalDate beginDate, LocalDate endDate) {
        HashMap reqParams = Maps.newHashMapWithExpectedSize((int)16);
        reqParams.put("AcctNo", accNo);
        reqParams.put("BeginDate", beginDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        reqParams.put("EndDate", endDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        return RequestPacker.getRequestXml("500002", corpId, reqParams);
    }

    public static String getRequestXml(String tranCode, String corpId, Map<String, String> reqParam) {
        Element root = JDomExtUtils.createRoot((String)"HTBankData");
        Element ReqData = new Element("ReqData");
        Element ReqParam = new Element("ReqParam");
        JDomExtUtils.addChild((Element)root, (Element)ReqData);
        JDomExtUtils.addChild((Element)ReqData, (Element)RequestPacker.getRequestHeadElement(tranCode, corpId));
        JDomExtUtils.addChild((Element)ReqData, (Element)ReqParam);
        for (Map.Entry<String, String> entry : reqParam.entrySet()) {
            String key = entry.getKey();
            JDomExtUtils.addChild((Element)ReqParam, (String)key, (String)reqParam.get(key));
        }
        return JDomExtUtils.doc2StrUTF8((Document)new Document(root));
    }

    public static Element getRequestHeadElement(String tranCode, String corpId) {
        Element root = JDomExtUtils.createRoot((String)"ReqHead");
        JDomUtils.addChild((Element)root, (String)"Version", (String)"1.0");
        JDomUtils.addChild((Element)root, (String)"TranCode", (String)tranCode);
        JDomUtils.addChild((Element)root, (String)"TermDate", (String)LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)root, (String)"TermTime", (String)LocalTime.now().format(DateTimeFormatter.ofPattern("HHmmss")));
        JDomUtils.addChild((Element)root, (String)"SeqNo", (String)RequestPacker.getSeqNo());
        JDomUtils.addChild((Element)root, (String)"CorpId", (String)corpId);
        return root;
    }

    public static String getSeqNo() {
        String uuid = UUID.randomUUID().toString();
        return uuid.replaceAll("-", "");
    }

    public static String get520003RequestXml(String corpId, String accNo, LocalDate oldTermDate, String oldSeqNo) {
        HashMap reqParams = Maps.newHashMapWithExpectedSize((int)16);
        reqParams.put("AcctNo", accNo);
        reqParams.put("OldTermDate", oldTermDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        reqParams.put("OldSeqNo", oldSeqNo);
        return RequestPacker.getRequestXml("520003", corpId, reqParams);
    }

    public static String get520005RequestXml(String corpId, String accNo, String hostTranDate, String hostSeqNo, String dcFlag, String dtlSeqNo) {
        HashMap reqParams = Maps.newHashMapWithExpectedSize((int)16);
        reqParams.put("AcctNo", accNo);
        reqParams.put("HostTranDate", hostTranDate);
        reqParams.put("HostSeqNo", hostSeqNo);
        reqParams.put("DcFlag", dcFlag);
        reqParams.put("DtlSeqNo", dtlSeqNo);
        return RequestPacker.getRequestXml("520005", corpId, reqParams);
    }
}

