/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ynhtb.dc.service.receipt.utils;

import com.google.common.collect.Maps;
import com.jcraft.jsch.ChannelSftp;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.core.utils.ErrorMsgUtil;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import org.jdom2.Element;

public class ResponseParser {
    public static Map<String, String> parse(String response) {
        if (StringUtils.isEmpty((String)response)) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a", (String)"ResponseParser_0", (String)"ebg-receipt-banks-ynhtb-dc", (Object[])new Object[0]));
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        Element root = JDomExtUtils.str2DocGBK((String)response).getRootElement();
        Element rspData = JDomExtUtils.getChildElement((Element)root, (String)"RspData");
        Element rspHead = rspData == null ? JDomExtUtils.getChildElement((Element)root, (String)"RspHead") : JDomExtUtils.getChildElement((Element)rspData, (String)"RspHead");
        String rspCode = JDomExtUtils.getChildElement((Element)rspHead, (String)"RspCode").getTextTrim();
        String rspMsg = JDomExtUtils.getChildElement((Element)rspHead, (String)"RspMsg").getTextTrim();
        if (!"000000".equals(rspCode)) {
            String msg = String.format(ResManager.loadKDString((String)"\u8c03\u7528\u7ea2\u5854\u94f6\u884c\u63a5\u53e3\u63a5\u6536\u5230\u94f6\u884c\u8fd4\u56de\u7684\u9519\u8bef\u62a5\u6587\uff0c\u8fd4\u56de\u7801[%1$s]:%2$s\u3002", (String)"ResponseParser_11", (String)"ebg-receipt-banks-ynhtb-dc", (Object[])new Object[0]), rspCode, rspMsg);
            throw new ReceiptException(msg);
        }
        Element result = JDomExtUtils.getChildElement((Element)rspData, (String)"Result");
        List lists = result.getChildren();
        for (Element element : lists) {
            map.put(element.getName(), element.getTextTrim());
        }
        return map;
    }

    public static List<DetailInfo> fileDownloadAndParse(DownloadListTask task, String file_name) {
        ArrayList<DetailInfo> detailInfoList = new ArrayList(16);
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, task.getBankLoginId());
        if (!bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u7ea2\u5854\u94f6\u884c\u4ec5\u652f\u6301\u901a\u8fc7sftp\u7684\u65b9\u5f0f\u83b7\u53d6\u6587\u4ef6\uff0c\u8bf7\u5728[\u914d\u7f6e\u9879]-[\u94f6\u884c\u914d\u7f6e]-[\u56de\u5355\u83b7\u53d6\u65b9\u5f0f]\u9009\u62e9\"\u8fdc\u7a0bsftp\u83b7\u53d6\"\u3002", (String)"ResponseParser_4", (String)"ebg-receipt-banks-ynhtb-dc", (Object[])new Object[0]));
        }
        String ftpPath = bankFtpProperties.getFtpPath();
        String tempPath = FileStorageUtil.getFileBakPath((String)"YNHTB_DC");
        File sourceFile = FileCommonUtils.getFileByPath((String)(tempPath + File.separator + file_name));
        boolean downloadFlag = ResponseParser.ftpDownload(EBGStringUtils.isEmpty((String)ftpPath) ? "/" : ftpPath, file_name, tempPath);
        if (!downloadFlag) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d\u67e5\u8be2\u660e\u7ec6\u6587\u4ef6%s\u5931\u8d25\u3002", (String)"ResponseParser_13", (String)"ebg-receipt-banks-ynhtb-dc", (Object[])new Object[0]), file_name));
        }
        detailInfoList = ResponseParser.parseFileContent(sourceFile);
        return detailInfoList;
    }

    private static boolean ftpDownload(String ftpPath, String orgFileName, String destFolder) {
        ChannelSftp sftp = null;
        boolean downloadFlag = false;
        try {
            if (SFTPUtils.getInstance().isAbort(sftp)) {
                sftp = SFTPUtils.getInstance().getSftp();
            }
            if (!ResponseParser.findFile(sftp, ftpPath, orgFileName)) {
                Thread.sleep(5000L);
            }
            downloadFlag = SFTPUtils.getInstance().downloadSingleFile(ftpPath, orgFileName, destFolder, sftp);
        }
        catch (Exception e) {
            try {
                String msg = ErrorMsgUtil.getSFTPErrorMSG((String)orgFileName, (String)e.getMessage());
                throw new ReceiptException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                SFTPUtils.getInstance().close(sftp);
                throw throwable;
            }
        }
        SFTPUtils.getInstance().close(sftp);
        return downloadFlag;
    }

    private static boolean findFile(ChannelSftp sftp, String ftpPath, String orgFileName) {
        try {
            Vector vector = sftp.ls(ftpPath);
            if (Objects.nonNull(vector) && vector.size() > 0) {
                for (Object o : vector) {
                    ChannelSftp.LsEntry file = (ChannelSftp.LsEntry)o;
                    if (!file.getFilename().equals(orgFileName)) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static List<DetailInfo> parseFileContent(File sourceFile) {
        ArrayList<DetailInfo> list;
        block32: {
            list = new ArrayList<DetailInfo>(16);
            String fileContent = "";
            if (sourceFile.exists()) {
                try (FileInputStream totalFileStream = new FileInputStream(sourceFile);
                     BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)totalFileStream, "GBK"));){
                    while ((fileContent = bufferedReader.readLine()) != null) {
                        String[] params = fileContent.split("\\|!");
                        String acctNo = params[0];
                        String tranDate = params[1];
                        String seqNo = params[9];
                        String dcFlag = params[8];
                        String tranAmt = params[3];
                        String dtlSeqNo = params[params.length - 1];
                        DetailInfo detailInfo = new DetailInfo();
                        detailInfo.setAccNo(acctNo);
                        detailInfo.setTransDate(LocalDate.parse(tranDate, DateTimeFormatter.ofPattern("yyyyMMdd")));
                        detailInfo.setExplanation(seqNo);
                        detailInfo.setDebitAmount(new BigDecimal(tranAmt));
                        detailInfo.setKdFlag(dcFlag);
                        detailInfo.setReversed1(dtlSeqNo);
                        list.add(detailInfo);
                    }
                    ((InputStream)totalFileStream).close();
                    break block32;
                }
                catch (Exception e) {
                    throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u660e\u7ec6\u6982\u8981\u6587\u4ef6%s\u5f02\u5e38\u3002", (String)"ResponseParser_14", (String)"ebg-receipt-banks-ynhtb-dc", (Object[])new Object[0]), sourceFile), (Throwable)e);
                }
                finally {
                    boolean isDelete = sourceFile.delete();
                    if (!isDelete || !sourceFile.exists()) {
                        // empty if block
                    }
                }
            }
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u6982\u8981\u6587\u4ef6%s\u4e0d\u5b58\u5728\uff0c\u8bf7\u548c\u94f6\u884c\u786e\u8ba4\u63a8\u9001\u8def\u5f84\uff0c\u6216\u8005\u94f6\u884c\u662f\u5426\u63a8\u9001\u6587\u4ef6\u3002", (String)"ResponseParser_15", (String)"ebg-receipt-banks-ynhtb-dc", (Object[])new Object[0]), sourceFile));
        }
        return list;
    }
}

