/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ccb.ccip.service.receipt;

import com.google.common.collect.Maps;
import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.receipt.banks.ccb.ccip.BankBusinessConfig;
import kd.ebg.receipt.banks.ccb.ccip.service.receipt.CCBCCIPCommConfig;
import kd.ebg.receipt.banks.ccb.ccip.service.receipt.CCBCCIPFileParser;
import kd.ebg.receipt.banks.ccb.ccip.service.receipt.message.biz.CCBReceiptNode;
import kd.ebg.receipt.banks.ccb.ccip.service.receipt.message.biz.FileInfoNode;
import kd.ebg.receipt.banks.ccb.ccip.service.receipt.message.biz.ReceiptIndexMessage;
import kd.ebg.receipt.banks.ccb.ccip.service.receipt.message.biz.newApi.ReceiptIndexMessageByNewApi;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        String bankLoginId = request.getBankLoginId();
        long taskId = request.getTaskId();
        DownloadListTask downloadListTask = this.downloadTaskService.findById(taskId);
        boolean isPushed = ((CCBCCIPCommConfig)EBConfigBuilder.getInstance().buildConfig(CCBCCIPCommConfig.class, bankLoginId)).getCcipPushMode().equals("true");
        List<Object> result = new ArrayList();
        result = !isPushed ? this.doJob_proxyMode(downloadListTask) : this.doJob_pushMode(downloadListTask);
        return BankReceiptHandleResponseEB.success(result);
    }

    public List<DownloadListDetail> doJob_proxyMode(DownloadListTask task) {
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>();
        try {
            List listDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(task.getId()));
            if (listDetails.size() > 0) {
                List ids;
                DownloadListDetail downloadListDetail = (DownloadListDetail)listDetails.get(0);
                CCBCCIPFileParser ccbdcFileParser = new CCBCCIPFileParser();
                ccbdcFileParser.setFileName(downloadListDetail.getFileName());
                int length = ccbdcFileParser.getFileSplitLength();
                if (length < 5 && BankBusinessConfig.isUserNewApi()) {
                    ids = listDetails.stream().map(o -> o.getId()).collect(Collectors.toList());
                    this.downloadListDetailService.deleteAll(ids);
                }
                if (length >= 5 && !BankBusinessConfig.isUserNewApi()) {
                    ids = listDetails.stream().map(o -> o.getId()).collect(Collectors.toList());
                    this.downloadListDetailService.deleteAll(ids);
                }
            }
        }
        catch (Throwable listDetails) {
            // empty catch block
        }
        try {
            ArrayList<CCBReceiptNode> ccbReceiptNodeList = new ArrayList(16);
            List<Object> fileInfos = new ArrayList(16);
            CCBCCIPCommConfig ccbccipCommConfig = (CCBCCIPCommConfig)EBConfigBuilder.getInstance().buildConfig(CCBCCIPCommConfig.class, task.getBankLoginId());
            if (BankBusinessConfig.isUserNewApi()) {
                String cstId = ccbccipCommConfig.getCstid();
                ccbReceiptNodeList = ReceiptIndexMessageByNewApi.getReceiptNodesByNewApi(task.getAccNo(), task.getTransDate(), task.getTransDate(), task.getBankLoginId());
                fileInfos = ReceiptIndexMessageByNewApi.getDownloadFileInfosByNewApi(ccbReceiptNodeList, task.getBankLoginId(), cstId);
            } else {
                ccbReceiptNodeList = ReceiptIndexMessage.getReceiptNodes(task.getAccNo(), task.getTransDate(), task.getTransDate(), task.getBankLoginId());
                fileInfos = ReceiptIndexMessage.getDownloadFileInfos(ccbReceiptNodeList, task.getBankLoginId());
            }
            if (fileInfos.size() == 0) {
                throw new ReceiptException(ResManager.loadKDString((String)"\u83b7\u53d6\u4e0b\u8f7d\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\uff1a\u8bf7\u68c0\u67e5\u4ea4\u6613\u660e\u7ec6\uff0c\u5982\u82e5\u5b58\u5728\uff0c\u9700\u7b49\u5f85\u4efb\u52a1\u81ea\u52a8\u91cd\u8bd5\u4e0b\u8f7d\u3002", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-ccb-ccip", (Object[])new Object[0]));
            }
            HashMap tempMap = Maps.newHashMapWithExpectedSize((int)8);
            for (FileInfoNode fileInfoNode : fileInfos) {
                String newFileName = CCBCCIPFileParser.createFileName(task.getAccNo(), task.getTransDate(), fileInfoNode.getReceiptNo(), fileInfoNode.getAmount(), tempMap);
                if (BankBusinessConfig.isUserNewApi()) {
                    newFileName = CCBCCIPFileParser.createFileNameByNewApi(task.getAccNo(), task.getTransDate(), fileInfoNode.getAmount(), fileInfoNode.getLogNo(), fileInfoNode.getTradeDetailId(), fileInfoNode.getDbtCrDrcCd(), tempMap);
                }
                DownloadListDetail detail = new DownloadListDetail();
                detail.setFileLink(fileInfoNode.getFileName());
                detail.setFileName(newFileName);
                result.add(detail);
            }
        }
        catch (Exception e) {
            throw new ReceiptException(e.getMessage(), (Throwable)e);
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_1", (String)"ebg-receipt-banks-ccb-ccip", (Object[])new Object[0]));
        }
        return result;
    }

    public List<DownloadListDetail> doJob_pushMode(DownloadListTask task) {
        ArrayList<DownloadListDetail> result = new ArrayList();
        String accNo = task.getAccNo();
        String transDateStr = task.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)task.getBankVersionId(), (String)accNo, (String)transDateStr);
        boolean flag = false;
        File bakFile = FileCommonUtils.getFileByPath((String)bakFilePath);
        PDFFilter fitler = new PDFFilter(accNo, transDateStr);
        if (bakFile.exists()) {
            logger.info("\u5efa\u8bbe\u94f6\u884c\u73b0\u91d1\u76f4\u8fde\u7248-\u56de\u5355\u603b\u5305\u5df2\u4e0b\u8f7d-\u65e5\u671f\uff1a{}-\u8d26\u53f7\uff1a{}", new Object[]{transDateStr, accNo});
            File[] files = bakFile.listFiles(fitler);
            if (files.length > 0) {
                for (int i = 0; i < files.length; ++i) {
                    DownloadListDetail detail = new DownloadListDetail();
                    detail.setFileName(files[i].getName());
                    result.add(detail);
                }
                flag = true;
            }
        }
        if (!flag) {
            result = this.getFileList(task);
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_1", (String)"ebg-receipt-banks-ccb-ccip", (Object[])new Object[0]));
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<DownloadListDetail> getFileList(DownloadListTask task) {
        LocalDate transDate;
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        String bankLoginId = task.getBankLoginId();
        LocalDate localDate = transDate = task.getTransDate();
        BankFtpProperties ftpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLoginId);
        String sftp_path = ftpProperties.getFtpPath();
        String ftpPath = sftp_path = EBGStringUtils.isNotEmpty((String)sftp_path) ? sftp_path : "/";
        ChannelSftp sftp = null;
        try {
            if (SFTPUtils.getInstance().isAbort(sftp)) {
                sftp = SFTPUtils.getInstance().getSftp();
            }
            if (sftp == null) {
                throw new ReceiptException(ResManager.loadKDString((String)"sftp\u8fde\u63a5\u5931\u8d25\u3002", (String)"BankReceiptFetchListImpl_2", (String)"ebg-receipt-banks-ccb-ccip", (Object[])new Object[0]));
            }
            Vector vector = sftp.ls(ftpPath);
            String fileName = "";
            for (int i = 0; i < vector.size(); ++i) {
                block10: {
                    ChannelSftp.LsEntry file = (ChannelSftp.LsEntry)vector.get(i);
                    fileName = file.getFilename();
                    if (!fileName.endsWith(".zip")) continue;
                    String fileDate = fileName.replaceAll("\\.zip", "");
                    String ld = localDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
                    if (!ld.equals(fileDate)) break block10;
                    String tempPath = FileStorageUtil.getFileBakPath((String)task.getBankLoginId()) + File.separator + transDate;
                    boolean flag = SFTPUtils.getInstance().downloadSingleFile(ftpPath, fileName, tempPath, sftp);
                    if (!flag) break block10;
                    List list = FileCommonUtils.getDetailList((DownloadListTask)task, (String)fileName);
                    SFTPUtils.getInstance().close(sftp);
                    return list;
                }
                continue;
                catch (Exception e) {
                    // empty catch block
                }
                continue;
            }
        }
        catch (Exception e) {
            try {
                String msg = String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5efa\u8bbe\u94f6\u884c\u7535\u5b50\u56de\u5355\u6587\u4ef6\u5217\u8868\u4efb\u52a1\uff0cSFTP\u53d1\u751f\u5f02\u5e38\uff1a%s\u3002\u8bf7\u68c0\u67e5\u56de\u5355\u5e73\u53f0\u5efa\u884cSFTP\u914d\u7f6e\u4fe1\u606f\u548cSFTP\u670d\u52a1\u662f\u5426\u6b63\u5e38\u8fd0\u884c\uff0c\u5e76\u4f7f\u7528SFTP\u5de5\u5177\u786e\u8ba4\u662f\u5426\u53ef\u8fde\u901a\u3002", (String)"BankReceiptFetchListImpl_6", (String)"ebg-receipt-banks-ccb-ccip", (Object[])new Object[0]), e.getMessage());
                throw new ReceiptException(msg, e.getCause());
            }
            catch (Throwable throwable) {
                SFTPUtils.getInstance().close(sftp);
                throw throwable;
            }
        }
        SFTPUtils.getInstance().close(sftp);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readZipFiles(String patchPath) {
        ArrayList<String> fileList = new ArrayList<String>();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(patchPath);
            Enumeration e = zipFile.getEntries();
            while (e.hasMoreElements()) {
                ZipEntry entry = (ZipEntry)e.nextElement();
                System.out.println(entry.getName());
                if (entry.isDirectory() || !entry.getName().endsWith(".pdf") && !entry.getName().endsWith(".PDF")) continue;
                fileList.add(entry.getName());
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (Exception exception) {}
        }
        return fileList;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CCB_CCIP_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u5efa\u8bbe\u94f6\u884c\u73b0\u91d1\u76f4\u8054\u7248\u56de\u5355\u6587\u4ef6\u5217\u8868\u3002", (String)"BankReceiptFetchListImpl_5", (String)"ebg-receipt-banks-ccb-ccip", (Object[])new Object[0]);
    }

    static class ZipFilter
    implements FileFilter {
        private String transDate;
        private String type;

        public ZipFilter(String type, String transDate) {
            this.type = type;
            this.transDate = transDate;
        }

        @Override
        public boolean accept(File file) {
            return file.getName().contains(this.transDate) && file.getName().contains(this.type);
        }
    }

    static class PDFFilter
    implements FileFilter {
        private String transDate;
        private String accNo;

        public PDFFilter(String accNo, String transDate) {
            this.accNo = accNo;
            this.transDate = transDate;
        }

        @Override
        public boolean accept(File file) {
            return file.getName().contains(this.transDate) && file.getName().contains(this.accNo);
        }
    }
}

