/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ccb.ccip.service.receipt.message;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.receipt.banks.ccb.ccip.service.receipt.CCBCCIPCommConfig;
import kd.ebg.receipt.banks.ccb.ccip.service.receipt.message.biz.FileInfoNode;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class CommonPacker {
    public Element packCommonHeader(String sysTXCode, String sequence, String traceID, String pageSize, String nextPage) throws Exception {
        String bankLoginId = EBContext.getContext().getBankLoginID();
        CCBCCIPCommConfig config = (CCBCCIPCommConfig)EBConfigBuilder.getInstance().buildConfig(CCBCCIPCommConfig.class, bankLoginId);
        Element root = new Element("Transaction_Header");
        JDomExtUtils.addChildCDData((Element)root, (String)"SYS_TX_CODE", (String)sysTXCode);
        JDomExtUtils.addChildCDData((Element)root, (String)"SYS_REQ_LEN", (String)"1021");
        SimpleDateFormat dateFormat = new SimpleDateFormat("hhmmssSSS");
        JDomExtUtils.addChildCDData((Element)root, (String)"SYS_REQ_TIME", (String)dateFormat.format(new Date()));
        JDomExtUtils.addChildCDData((Element)root, (String)"SYS_TX_VRSN", (String)"01");
        Date date = new Date();
        JDomExtUtils.addChildCDData((Element)root, (String)"TXN_DT", (String)LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomExtUtils.addChildCDData((Element)root, (String)"TXN_TM", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("HHmmss")));
        String opNo = config.getCusopr();
        JDomExtUtils.addChildCDData((Element)root, (String)"TXN_STFF_ID", (String)opNo);
        JDomExtUtils.addChildCDData((Element)root, (String)"MULTI_TENANCY_ID", (String)"CN000");
        JDomExtUtils.addChildCDData((Element)root, (String)"LNG_ID", (String)"zh-cn");
        JDomExtUtils.addChildCDData((Element)root, (String)"REC_IN_PAGE", (String)pageSize);
        JDomExtUtils.addChildCDData((Element)root, (String)"PAGE_JUMP", (String)nextPage);
        JDomExtUtils.addChildCDData((Element)root, (String)"STS_TRACE_ID", (String)traceID);
        String coustomerNo = config.getPrimarno();
        JDomExtUtils.addChildCDData((Element)root, (String)"CHNL_CUST_NO", (String)coustomerNo);
        JDomExtUtils.addChildCDData((Element)root, (String)"IttParty_Jrnl_No", (String)sequence);
        String ip = "";
        JDomExtUtils.addChildCDData((Element)root, (String)"Txn_Itt_IP_Adr", (String)ip);
        return root;
    }

    public Element packCommonHeader(String sysTXCode, String sequence) throws Exception {
        return this.packAutoCommonHeader(sysTXCode, sequence, "100", "1");
    }

    public Element packAutoCommonHeader(String sysTXCode, String sequence, String pageSize, String nextPage) throws Exception {
        return this.packCommonHeader(sysTXCode, sequence, "", pageSize, nextPage);
    }

    public Element packComEntity(String proCode, String fileName, String sequence) throws Exception {
        return this.packComEntity(proCode, "000000000000000", "000000000000000", fileName, sequence, "01");
    }

    public Element packComEntity(String proCode, String sequence) throws Exception {
        return this.packComEntity(proCode, "000000000000000", "000000000000000", "", sequence, "01");
    }

    public Element packComEntity(String proCode, String schlNo, String fwctlNodeID, String fileName, String sequence, String functionCode) throws Exception {
        String bankLoginId = EBContext.getContext().getBankLoginID();
        CCBCCIPCommConfig config = (CCBCCIPCommConfig)EBConfigBuilder.getInstance().buildConfig(CCBCCIPCommConfig.class, bankLoginId);
        Element root = new Element("request");
        JDomExtUtils.addChildCDData((Element)root, (String)"ASPD_ECD", (String)proCode);
        JDomExtUtils.addChildCDData((Element)root, (String)"SChl_No", (String)schlNo);
        JDomExtUtils.addChildCDData((Element)root, (String)"FwCtl_Node_ID", (String)fwctlNodeID);
        JDomExtUtils.addChildCDData((Element)root, (String)"IttParty_Bsn_Dt", (String)LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
        String grpid = config.getGrpid();
        JDomExtUtils.addChildCDData((Element)root, (String)"Grp_ID", (String)grpid);
        String cstid = config.getCstid();
        JDomExtUtils.addChildCDData((Element)root, (String)"Cst_ID", (String)cstid);
        String primarno = config.getPrimarno();
        JDomExtUtils.addChildCDData((Element)root, (String)"Prim_AR_No", (String)primarno);
        JDomExtUtils.addChildCDData((Element)root, (String)"Root_Node_PdAr_ID", (String)"");
        JDomExtUtils.addChildCDData((Element)root, (String)"PdAr_ID", (String)"");
        JDomExtUtils.addChildCDData((Element)root, (String)"SvM24Hr_Ind", (String)"0");
        JDomExtUtils.addChildCDData((Element)root, (String)"Tmzon_ECD", (String)"08");
        JDomExtUtils.addChildCDData((Element)root, (String)"Rqs_Upload_File_Nm", (String)fileName);
        JDomExtUtils.addChildCDData((Element)root, (String)"Cmpt_Ent_ID", (String)"0000CN000");
        JDomExtUtils.addChildCDData((Element)root, (String)"WF_BIZ_ID", (String)sequence);
        JDomExtUtils.addChildCDData((Element)root, (String)"WF_MNPLT_TP", (String)functionCode);
        JDomExtUtils.addChildCDData((Element)root, (String)"WF_FCN_ID", (String)"");
        String ccsttrid = config.getCcsttrid();
        JDomExtUtils.addChildCDData((Element)root, (String)"CCstTr_ID", (String)ccsttrid);
        String ccstrndid = config.getCcsttrnddid();
        JDomExtUtils.addChildCDData((Element)root, (String)"CCstTrNdID", (String)ccstrndid);
        return root;
    }

    public String packFileRequest(String type, String fileName, String content) throws Exception {
        Element root = new Element("frontProxyRequst");
        Element heaser = JDomExtUtils.addChild((Element)root, (String)"header");
        JDomExtUtils.addChildCDData((Element)heaser, (String)"sequnce", (String)(Sequence.genSequence() + ""));
        JDomExtUtils.addChildCDData((Element)heaser, (String)"type", (String)type);
        Element body = JDomExtUtils.addChild((Element)root, (String)"body");
        JDomExtUtils.addChildCDData((Element)body, (String)"bankFile", (String)content);
        JDomExtUtils.addChildCDData((Element)body, (String)"fileName", (String)fileName);
        return JDomExtUtils.doc2StrUTF8((Document)new Document(root));
    }

    public Element packFileEntity(List<FileInfoNode> fileInfoNodes) throws Exception {
        Element fileListPack = new Element("FILE_LIST_PACK");
        JDomExtUtils.addChildCDData((Element)fileListPack, (String)"FILE_NUM", (String)(fileInfoNodes.size() + ""));
        for (FileInfoNode info : fileInfoNodes) {
            Element fileInfo = JDomExtUtils.addChild((Element)fileListPack, (String)"FILE_INFO");
            JDomExtUtils.addChildCDData((Element)fileInfo, (String)"FILE_NAME", (String)info.getFileName());
            JDomExtUtils.addChildCDData((Element)fileInfo, (String)"Msg_Smy", (String)info.getMd5());
        }
        return fileListPack;
    }

    public Element packFileEntity(FileInfoNode fileInfoNodes) throws Exception {
        Element fileListPack = new Element("FILE_LIST_PACK");
        JDomExtUtils.addChildCDData((Element)fileListPack, (String)"FILE_NUM", (String)"1");
        Element fileInfo = JDomExtUtils.addChild((Element)fileListPack, (String)"FILE_INFO");
        JDomExtUtils.addChildCDData((Element)fileInfo, (String)"FILE_NAME", (String)fileInfoNodes.getFileName());
        JDomExtUtils.addChildCDData((Element)fileInfo, (String)"Msg_Smy", (String)fileInfoNodes.getMd5());
        return fileListPack;
    }

    public String packUploadFrontMsg(String bankMsg, FileInfoNode node) throws Exception {
        return this.packFileRequest("upload", node.getFileName(), node.getFileContent());
    }
}

