/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ccb.ccip.service.receipt.message;

import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.receipt.banks.ccb.ccip.service.receipt.api.GetBankReceiptDownloadImpl;
import kd.ebg.receipt.banks.ccb.ccip.service.receipt.api.GetBankReceiptFileImpl;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import org.apache.commons.codec.binary.Base64;
import org.jdom2.Document;
import org.jdom2.Element;

public class RequestUtil {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(RequestUtil.class);

    public static final String getDownloadFileRequestStr(String fileName) {
        Element root = JDomExtUtils.createRoot((String)"frontProxyRequst");
        Element header = JDomExtUtils.addChild((Element)root, (String)"header");
        JDomExtUtils.addChildText((Element)header, (String)"sequnce", (String)(Sequence.genSequence() + ""));
        JDomExtUtils.addChildText((Element)header, (String)"type", (String)"download");
        Element body = JDomExtUtils.addChild((Element)root, (String)"body");
        JDomExtUtils.addChildCDData((Element)body, (String)"fileName", (String)fileName);
        JDomExtUtils.addChildCDData((Element)body, (String)"bankFile", (String)"receiptDownload");
        Document document = new Document(root);
        return JDomExtUtils.doc2StrUTF8((Document)document);
    }

    public static final String getResponse(String rsp) {
        String result = "";
        Document doc = JDomExtUtils.str2Doc((String)rsp, (String)"UTF-8");
        Element root = doc.getRootElement();
        Element header = JDomExtUtils.getChildElement((Element)root, (String)"header");
        String returnCode = JDomExtUtils.getChildText((Element)header, (String)"returnCode");
        String returnMsg = JDomExtUtils.getChildText((Element)header, (String)"returnMsg");
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"body");
        if (!"0000".equals(returnCode)) {
            logger.error("\u524d\u7f6e\u673a\u8fd4\u56de\u9519\u8bef\uff1a" + returnCode + returnMsg);
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u524d\u7f6e\u673a\u8fd4\u56de\u9519\u8bef\uff1a[%1$s]%2$s\u3002", (String)"RequestUtil_1", (String)"ebg-receipt-banks-ccb-ccip", (Object[])new Object[0]), returnCode, returnMsg));
        }
        try {
            result = JDomExtUtils.getChildText((Element)body, (String)"bankMsg");
            result = new String(Base64.decodeBase64((String)result), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("", (Throwable)e);
        }
        return result;
    }

    public static final byte[] getResponseBytes(String rsp) {
        byte[] result = null;
        Document doc = JDomExtUtils.str2Doc((String)rsp, (String)"UTF-8");
        Element root = doc.getRootElement();
        Element header = JDomExtUtils.getChildElement((Element)root, (String)"header");
        String returnCode = JDomExtUtils.getChildText((Element)header, (String)"returnCode");
        String returnMsg = JDomExtUtils.getChildText((Element)header, (String)"returnMsg");
        if (!"0000".equals(returnCode)) {
            logger.error("\u524d\u7f6e\u673a\u8fd4\u56de\u9519\u8bef\uff1a" + returnCode + returnMsg);
        } else {
            Element body = JDomExtUtils.getChildElement((Element)root, (String)"body");
            String temp = JDomExtUtils.getChildText((Element)body, (String)"bankMsg");
            result = Base64.decodeBase64((String)temp);
        }
        return result;
    }

    public static byte[] hexStr2Byte(String hexStr) {
        String str = "0123456789ABCDEF";
        char[] hexs = hexStr.toCharArray();
        byte[] bytes = new byte[hexStr.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            int n = str.indexOf(hexs[2 * i]) * 16;
            bytes[i] = (byte)((n += str.indexOf(hexs[2 * i + 1])) & 0xFF);
        }
        return bytes;
    }

    public static final String sendReq2Proxy(String data) {
        HashMap paramsMap = Maps.newHashMapWithExpectedSize((int)8);
        paramsMap.put("requestStr", data);
        BankReceiptRequest request = BankReceiptRequest.builder().paramsMap((Map)paramsMap).build();
        GetBankReceiptDownloadImpl iBankReceipt = new GetBankReceiptDownloadImpl();
        BankReceiptResponseEB receiptResponseEB = (BankReceiptResponseEB)iBankReceipt.doBiz((BankRequest)request);
        String responseStr = (String)receiptResponseEB.getData();
        return RequestUtil.getResponse(responseStr);
    }

    public static final String sendFileReq2Proxy(String data) {
        HashMap paramsMap = Maps.newHashMapWithExpectedSize((int)8);
        paramsMap.put("requestStr", data);
        BankReceiptRequest request = BankReceiptRequest.builder().paramsMap((Map)paramsMap).build();
        GetBankReceiptFileImpl iBankReceipt = new GetBankReceiptFileImpl();
        BankReceiptResponseEB receiptResponseEB = (BankReceiptResponseEB)iBankReceipt.doBiz((BankRequest)request);
        String responseStr = (String)receiptResponseEB.getData();
        return RequestUtil.getResponse(responseStr);
    }
}

