/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ccb.ccip.service.receipt.message.biz;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.receipt.banks.ccb.ccip.service.receipt.CCBCCIPCommConfig;
import kd.ebg.receipt.banks.ccb.ccip.service.receipt.message.CCBHCBankResponse;
import kd.ebg.receipt.banks.ccb.ccip.service.receipt.message.CommonPacker;
import kd.ebg.receipt.banks.ccb.ccip.service.receipt.message.CommonParser;
import kd.ebg.receipt.banks.ccb.ccip.service.receipt.message.RequestUtil;
import kd.ebg.receipt.banks.ccb.ccip.service.receipt.message.biz.CCBReceiptNode;
import kd.ebg.receipt.banks.ccb.ccip.service.receipt.message.biz.FileInfoNode;
import kd.ebg.receipt.banks.ccb.ccip.service.receipt.message.biz.ReceiptIndexPage;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.core.utils.ErrorMsgUtil;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import kd.ebg.receipt.common.utils.PropertiesConstantsUtils;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public class ReceiptIndexMessage {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptIndexMessage.class);
    private static final String DOWNLOADNODES_SEPERATOR = ",";
    private static final int DOWNLOAD_RECEIPTLIST_SIZE = 1;

    public static final List<FileInfoNode> getDownloadFileInfos(List<CCBReceiptNode> ccbReceiptNodeList, String bankLogin) {
        ArrayList<FileInfoNode> fileInfoNodeList = new ArrayList<FileInfoNode>(16);
        logger.info("\u83b7\u53d6\u7684\u56de\u5355\u6807\u53f7\u6570\u91cf\u4e3a:" + ccbReceiptNodeList.size());
        if (ccbReceiptNodeList.size() == 0) {
            return fileInfoNodeList;
        }
        String accNo = ccbReceiptNodeList.get(0).getAccNo();
        int count = 0;
        do {
            ArrayList<String> downloadReceiptNo = new ArrayList<String>(16);
            for (int i = 0; i < 1 && count < ccbReceiptNodeList.size(); ++i) {
                CCBReceiptNode receiptNode = ccbReceiptNodeList.get(count);
                if (EBGStringUtils.isEmpty((String)receiptNode.getLogNo())) continue;
                downloadReceiptNo.add(receiptNode.getLogNo());
                ++count;
            }
            if (downloadReceiptNo.size() == 0) continue;
            String rspStr = "";
            try {
                String requstString = ReceiptIndexMessage.getDownloadReqStr(accNo, downloadReceiptNo);
                rspStr = RequestUtil.sendReq2Proxy(requstString);
                fileInfoNodeList.addAll(ReceiptIndexMessage.parserDownloadReceiptRsp(accNo, rspStr));
            }
            catch (Exception e) {
                logger.error("CCB_CCIP\u56de\u5355\u4e0b\u8f7d\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                if (Objects.nonNull(e) && Objects.nonNull(e.getMessage()) && e.getMessage().contains(PropertiesConstantsUtils.getValue((String)"CCIP_TRANS_UNKOWN"))) {
                    logger.error("\u5f53\u524d\u6709\u95ee\u9898\u7684\u56de\u5355\u53f7: " + downloadReceiptNo);
                    continue;
                }
                throw new ReceiptException(String.format(ResManager.loadKDString((String)"CCB_CCIP\u56de\u5355\u4e0b\u8f7d\u51fa\u73b0\u5f02\u5e38\uff0c%s\u3002", (String)"ReceiptIndexMessage_5", (String)"ebg-receipt-banks-ccb-ccip", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            }
        } while (count < ccbReceiptNodeList.size());
        for (int i = 0; i < ccbReceiptNodeList.size(); ++i) {
            CCBReceiptNode receiptNode;
            if (i >= fileInfoNodeList.size() || null == (receiptNode = ccbReceiptNodeList.get(i))) continue;
            ((FileInfoNode)fileInfoNodeList.get(i)).setReceiptNo(receiptNode.getReceiptNo());
            ((FileInfoNode)fileInfoNodeList.get(i)).setAccNo(receiptNode.getAccNo());
            ((FileInfoNode)fileInfoNodeList.get(i)).setTransDate(receiptNode.getTranDate());
            ((FileInfoNode)fileInfoNodeList.get(i)).setAmount(receiptNode.getTxAmount().toString());
        }
        return fileInfoNodeList;
    }

    private static List<FileInfoNode> parserDownloadReceiptRsp(String accNo, String rspStr) throws Exception {
        ArrayList<FileInfoNode> result = new ArrayList(16);
        Document doc = JDomExtUtils.str2DocUTF8((String)rspStr);
        Element root = doc.getRootElement();
        CCBHCBankResponse response = CommonParser.getBankPreResponse(rspStr);
        if (!response.isSuccess() || !response.isPaySuccess()) {
            throw new Exception(String.format(ResManager.loadKDString((String)"\u89e3\u6790\u7535\u5b50\u56de\u5355\u7d22\u5f15\u5931\u8d25\uff0c%s\u3002", (String)"ReceiptIndexMessage_6", (String)"ebg-receipt-banks-ccb-ccip", (Object[])new Object[0]), response.getResponseCode()));
        }
        result = CommonParser.getRespFilesInfos(root);
        return result;
    }

    public static String getDownloadReqStr(String accNo, List<String> downloadReceiptNo) throws Exception {
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        CommonPacker packer = new CommonPacker();
        String bankLoginId = EBContext.getContext().getBankLoginID();
        CCBCCIPCommConfig config = (CCBCCIPCommConfig)EBConfigBuilder.getInstance().buildConfig(CCBCCIPCommConfig.class, bankLoginId);
        Element headr = packer.packCommonHeader(config.getDownloadReceiptMod(), Sequence.genSequence() + "");
        root.addContent((Content)headr);
        Element request = packer.packComEntity("00000886", Sequence.genSequence() + "");
        body.addContent((Content)request);
        JDomExtUtils.addChildCDData((Element)request, (String)"ACCT_NO", (String)accNo);
        JDomExtUtils.addChildCDData((Element)request, (String)"DOWNLOAD_NOS", (String)ReceiptIndexMessage.getDownloadNodes(downloadReceiptNo));
        return JDomExtUtils.doc2StrUTF8((Document)new Document(root));
    }

    private static String getDownloadNodes(List<String> downloadReceiptNo) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < downloadReceiptNo.size(); ++i) {
            sb.append(downloadReceiptNo.get(i));
            if (i >= downloadReceiptNo.size() - 1) continue;
            sb.append(DOWNLOADNODES_SEPERATOR);
        }
        return sb.toString();
    }

    private static String getIndexReqStr(String accNo, LocalDate startDate, LocalDate endDate, String pageTag) throws Exception {
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        CommonPacker packer = new CommonPacker();
        Element headr = packer.packAutoCommonHeader("P1CCMS001", Sequence.genSequence() + "", "100", pageTag);
        root.addContent((Content)headr);
        Element request = packer.packComEntity("00000886", Sequence.genSequence() + "");
        body.addContent((Content)request);
        JDomExtUtils.addChildCDData((Element)request, (String)"ACCT_NO", (String)accNo);
        JDomExtUtils.addChildCDData((Element)request, (String)"BEGIN_DATE", (String)startDate.format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomExtUtils.addChildCDData((Element)request, (String)"END_DATE", (String)endDate.format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomExtUtils.addChildCDData((Element)request, (String)"PAGE_NO", (String)pageTag);
        JDomExtUtils.addChildCDData((Element)request, (String)"INQUIRE_NUM", (String)"100");
        return JDomExtUtils.doc2StrUTF8((Document)new Document(root));
    }

    private static List<CCBReceiptNode> parseReceiptNodes(String accNo, String rspStr) throws Exception {
        ArrayList<CCBReceiptNode> result = new ArrayList<CCBReceiptNode>(16);
        Document doc = JDomExtUtils.str2DocUTF8((String)rspStr);
        Element root = doc.getRootElement();
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element responseElement = JDomExtUtils.getChildElement((Element)body, (String)"response");
        CCBHCBankResponse response = CommonParser.getBankPreResponse(rspStr);
        if (!response.isSuccess()) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u89e3\u6790\u7535\u5b50\u56de\u5355\u7d22\u5f15\u5931\u8d25\uff0c%s\u3002", (String)"ReceiptIndexMessage_6", (String)"ebg-receipt-banks-ccb-ccip", (Object[])new Object[0]), response.getResponseCode()));
        }
        List recordList = responseElement.getChildren("Record");
        for (Element node : recordList) {
            String receiptNo = JDomExtUtils.getChildText((Element)node, (String)"INNER_NO");
            String tranDateStr = JDomExtUtils.getChildText((Element)node, (String)"TRAN_DATE");
            String logNo = JDomExtUtils.getChildText((Element)node, (String)"LOG_NO");
            String crCode = JDomExtUtils.getChildText((Element)node, (String)"CR_COD");
            String txAmt = JDomExtUtils.getChildText((Element)node, (String)"TX_AMT");
            String oppAccNo = JDomExtUtils.getChildText((Element)node, (String)"OP_ACCT_NO");
            if (EBGStringUtils.isEmpty((String)receiptNo)) continue;
            BigDecimal amt = BigDecimal.ZERO;
            if (null != txAmt) {
                amt = new BigDecimal(txAmt);
            }
            LocalDate tranDate = LocalDate.parse(tranDateStr, DateTimeFormatter.BASIC_ISO_DATE);
            CCBReceiptNode receiptNode = new CCBReceiptNode();
            receiptNode.setReceiptNo(logNo);
            receiptNode.setLogNo(receiptNo);
            receiptNode.setOppAccNo(oppAccNo);
            receiptNode.setTranDate(tranDate);
            receiptNode.setAccNo(accNo);
            receiptNode.setTxAmount(amt);
            receiptNode.setDbtCrDrcCd(crCode);
            result.add(receiptNode);
        }
        return result;
    }

    public static final List<CCBReceiptNode> getReceiptNodes(String accNo, LocalDate startDate, LocalDate endDate, String bankLogin) {
        ArrayList<CCBReceiptNode> result = new ArrayList<CCBReceiptNode>(16);
        ReceiptIndexPage page = new ReceiptIndexPage();
        String pageTag = page.getFirstPage();
        String rspStr = "";
        try {
            do {
                String reqStr;
                if ((rspStr = RequestUtil.sendReq2Proxy(reqStr = ReceiptIndexMessage.getIndexReqStr(accNo, startDate, endDate, pageTag))).contains(PropertiesConstantsUtils.getValue((String)"UNKOWN_IP"))) {
                    throw new ReceiptException(String.format(ResManager.loadKDString((String)"%s\uff0c\u8bf7\u5c06IP\u5730\u5740\u914d\u7f6e\u5728\u5efa\u884c\u524d\u7f6e\u673a\u4ee3\u7406\u767d\u540d\u5355\uff08life.ng.config.xml\u7684\"AllowIP\"\uff09\u3002", (String)"ReceiptIndexMessage_7", (String)"ebg-receipt-banks-ccb-ccip", (Object[])new Object[0]), reqStr));
                }
                result.addAll(ReceiptIndexMessage.parseReceiptNodes(accNo, rspStr));
            } while (page.hasNext(rspStr, pageTag = page.getNext(rspStr, pageTag)));
        }
        catch (Exception e) {
            String msg = ErrorMsgUtil.getLinkErrorMSG((String)e.getMessage());
            logger.error("\u67e5\u8be2CCB_CCIP\u56de\u5355\u53f7\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw new ReceiptException(msg, (Throwable)e);
        }
        return result;
    }
}

