/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cbhb.dc.service.receipt.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kd.ebg.receipt.banks.cbhb.dc.service.receipt.api.BankFileRequestApiImpl;
import kd.ebg.receipt.banks.cbhb.dc.service.receipt.api.BankRequestApiImpl;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;

public class SocketUtils {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(SocketUtils.class);

    public static String sendRequest(String request, String host, int port) {
        BankRequestApiImpl bankRequestApi = new BankRequestApiImpl();
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().requestStr(request).build();
        BankReceiptResponseEB receiptResponseEB = bankRequestApi.doBiz(bankReceiptRequest);
        return (String)receiptResponseEB.getData();
    }

    public static String sendDownloadRequest(String fileName, String host, int port) {
        BankFileRequestApiImpl bankRequestApi = new BankFileRequestApiImpl();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("FILED3");
        String fileNameLength = String.valueOf(fileName.length());
        String fileNameLenStr = SocketUtils.fillToken(fileNameLength, "0", -4);
        stringBuilder.append(fileNameLenStr);
        stringBuilder.append(fileName);
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().requestStr(stringBuilder.toString()).build();
        RequestContextUtils.setRunningParam((String)"receipt_file_port", (String)Integer.toString(port));
        BankReceiptResponseEB receiptResponseEB = bankRequestApi.doBiz(bankReceiptRequest);
        return (String)receiptResponseEB.getData();
    }

    public static void writeFileName(OutputStream os, String fileName) throws IOException {
        String fileNameLength = String.valueOf(fileName.length());
        String fileNameLenStr = SocketUtils.fillToken(fileNameLength, "0", -4);
        os.write(fileNameLenStr.getBytes());
        os.write(fileName.getBytes());
    }

    public static String fillToken(String entity, String token, int length) {
        StringBuilder result = new StringBuilder();
        if (token == null || token.equals("")) {
            token = "0";
        }
        if (token.length() > 1) {
            token = token.substring(0, 1);
        }
        if (entity == null || entity.length() <= 0) {
            entity = "";
        }
        StringBuilder tmpStr = new StringBuilder();
        int size = Math.abs(length) - entity.length();
        if (size < 0) {
            size = 0;
        }
        for (int i = 0; i < size; ++i) {
            tmpStr.append(token);
        }
        if (length > 0) {
            result.append(entity).append((CharSequence)tmpStr);
        } else {
            result.append((CharSequence)tmpStr).append(entity);
        }
        return result.toString();
    }

    public static byte[] readBytes(InputStream in, int length) throws IOException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        byte[] buffer = new byte[length];
        int cur = in.read(buffer, 0, length);
        bo.write(buffer, 0, cur);
        return bo.toByteArray();
    }
}

