/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.hrxjb.dc.service.util;

import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.string.StringFormater;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import org.jdom2.Element;

public class RequestPacker {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(RequestPacker.class);

    public static String detailRequest(String accNo, String tranDate) {
        String tr_code = "200110";
        Element root = new Element("ap");
        JDomUtils.addChild((Element)root, (Element)RequestPacker.getRequestHeadPacker(tr_code, "0", "0"));
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)"01");
        JDomUtils.addChild((Element)body, (String)"start_date", (String)tranDate);
        JDomUtils.addChild((Element)body, (String)"end_date", (String)tranDate);
        String request = JDomUtils.e2Str((Element)root, (String)"    ", (String)"GBK", (boolean)true);
        return RequestPacker.createCommonMsg(request);
    }

    public static String receiptRequest(String accNo, String tranDate, String host_serial_no) {
        String tr_code = "200219";
        Element root = new Element("ap");
        JDomUtils.addChild((Element)root, (Element)RequestPacker.getRequestHeadPacker(tr_code, "0", "0"));
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)"01");
        JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)tranDate);
        JDomUtils.addChild((Element)body, (String)"host_serial_no", (String)host_serial_no);
        String request = JDomUtils.e2StrGBK((Element)root);
        return RequestPacker.createCommonMsg(request);
    }

    public static Element getRequestHeadPacker(String tr_code, String sign, String file_flag) {
        String req_no = Sequence.gen16Sequence() + "0";
        String dateTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        String tr_acdt = dateTime.substring(0, 8);
        String tr_time = dateTime.substring(8);
        Element head = new Element("head");
        JDomUtils.addChild((Element)head, (String)"tr_code", (String)tr_code);
        JDomUtils.addChild((Element)head, (String)"cms_corp_no", (String)"");
        JDomUtils.addChild((Element)head, (String)"user_no", (String)"");
        JDomUtils.addChild((Element)head, (String)"org_code", (String)"");
        JDomUtils.addChild((Element)head, (String)"serial_no", (String)"");
        JDomUtils.addChild((Element)head, (String)"req_no", (String)req_no);
        JDomUtils.addChild((Element)head, (String)"tr_acdt", (String)tr_acdt);
        JDomUtils.addChild((Element)head, (String)"tr_time", (String)tr_time);
        JDomUtils.addChild((Element)head, (String)"channel", (String)"5");
        JDomUtils.addChild((Element)head, (String)"sign", (String)sign);
        JDomUtils.addChild((Element)head, (String)"file_flag", (String)file_flag);
        JDomUtils.addChild((Element)head, (String)"reserved", (String)"");
        return head;
    }

    public static String createCommonMsg(String request) {
        String msgBody = "00" + request;
        String msgHead = String.valueOf(msgBody.length());
        try {
            msgHead = StringFormater.formatLen((String)msgHead, (int)10, (boolean)true, (char)'0', (String)"GBK");
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage());
            throw new ReceiptException((Throwable)e);
        }
        return msgHead + msgBody;
    }
}

