/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.hrxjb.dc.service.util;

import com.jcraft.jsch.ChannelSftp;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.hrxjb.dc.service.util.FileInfo;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.core.utils.ErrorMsgUtil;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import org.jdom2.Element;

public class ResponseParser {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ResponseParser.class);

    public static List<FileInfo> detailResponseParser(DownloadListTask task, String response) {
        List<FileInfo> fileInfos = new ArrayList<FileInfo>();
        if (StringUtils.isEmpty((String)response)) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a", (String)"ResponseParser_0", (String)"ebg-receipt-banks-hrxjb-dc", (Object[])new Object[0]));
        }
        Element root = JDomExtUtils.str2DocGBK((String)response).getRootElement();
        Element head = JDomExtUtils.getChildElement((Element)root, (String)"head");
        String ret_code = JDomUtils.getUnNullChildElement((Element)head, (String)"ret_code").getTextTrim();
        String succ_flag = JDomUtils.getUnNullChildElement((Element)head, (String)"succ_flag").getTextTrim();
        String ret_info = JDomUtils.getUnNullChildElement((Element)head, (String)"ret_info").getTextTrim();
        String ext_info = JDomUtils.getUnNullChildElement((Element)head, (String)"ext_info").getTextTrim();
        if (!"0".equals(succ_flag)) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25,\u672a\u80fd\u6b63\u5e38\u8fd4\u56de\u3002 \u6210\u529f\u6807\u5fd7%s", (String)"ResponseParser_13", (String)"ebg-receipt-banks-hrxjb-dc", (Object[])new Object[0]), succ_flag) + String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u7801\uff1a%s", (String)"ResponseParser_14", (String)"ebg-receipt-banks-hrxjb-dc", (Object[])new Object[0]), ret_code) + String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u4fe1\u606f%s", (String)"ResponseParser_15", (String)"ebg-receipt-banks-hrxjb-dc", (Object[])new Object[0]), ret_info + ext_info));
        }
        if (!"0000".equals(ret_code)) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25,\u672a\u80fd\u6b63\u5e38\u8fd4\u56de\u3002 \u6210\u529f\u6807\u5fd7%s", (String)"ResponseParser_13", (String)"ebg-receipt-banks-hrxjb-dc", (Object[])new Object[0]), succ_flag) + String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u7801\uff1a%s", (String)"ResponseParser_14", (String)"ebg-receipt-banks-hrxjb-dc", (Object[])new Object[0]), ret_code) + String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u4fe1\u606f%s", (String)"ResponseParser_15", (String)"ebg-receipt-banks-hrxjb-dc", (Object[])new Object[0]), ret_info + ext_info));
        }
        String file_flag = JDomUtils.getUnNullChildElement((Element)head, (String)"file_flag").getTextTrim();
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"body");
        String record_num = JDomUtils.getUnNullChildElement((Element)body, (String)"record_num").getTextTrim();
        if ("0".equals(record_num)) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u8d26\u53f7\uff1a%s", (String)"ResponseParser_16", (String)"ebg-receipt-banks-hrxjb-dc", (Object[])new Object[0]), task.getAccNo()) + String.format(ResManager.loadKDString((String)"\u5728\u65e5\u671f\uff1a%s\u6ca1\u6709\u4ea4\u6613\u4fe1\u606f\u3002", (String)"ResponseParser_17", (String)"ebg-receipt-banks-hrxjb-dc", (Object[])new Object[0]), task.getTransDate()));
        }
        if ("1".equals(file_flag)) {
            String file_name = JDomUtils.getUnNullChildElement((Element)body, (String)"file_name").getTextTrim();
            fileInfos = ResponseParser.fileDownloadAndparse(task, file_name);
        } else if ("0".equals(file_flag)) {
            String field_num = JDomUtils.getUnNullChildElement((Element)body, (String)"field_num").getTextTrim();
            String serial_record = JDomUtils.getUnNullChildElement((Element)body, (String)"serial_record").getTextTrim();
            int recordNum = -1;
            if (!StringUtils.isEmpty((String)record_num)) {
                recordNum = Integer.parseInt(record_num);
            }
            int fieldNum = -1;
            if (!StringUtils.isEmpty((String)field_num)) {
                fieldNum = Integer.parseInt(field_num);
            }
            FileInfo info = null;
            String[][] str = ResponseParser.parseTwoDimensionalArray(serial_record, recordNum, fieldNum);
            for (int i = 0; i < str.length; ++i) {
                String[] str_i = str[i];
                info = new FileInfo();
                info.setHOST_SERIAL_NO(str_i[5]);
                info.setCRDR_FLAG(str_i[23]);
                info.setAMT(str_i[24]);
                fileInfos.add(info);
            }
        }
        return fileInfos;
    }

    public static String receiptResponseParse(String response) {
        Element root = JDomExtUtils.str2DocGBK((String)response).getRootElement();
        Element head = JDomExtUtils.getChildElement((Element)root, (String)"head");
        String ret_code = JDomUtils.getUnNullChildElement((Element)head, (String)"ret_code").getTextTrim();
        String succ_flag = JDomUtils.getUnNullChildElement((Element)head, (String)"succ_flag").getTextTrim();
        String ret_info = JDomUtils.getUnNullChildElement((Element)head, (String)"ret_info").getTextTrim();
        String ext_info = JDomUtils.getUnNullChildElement((Element)head, (String)"ext_info").getTextTrim();
        if (!"0".equals(succ_flag)) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25,\u672a\u80fd\u6b63\u5e38\u8fd4\u56de\u3002 \u6210\u529f\u6807\u5fd7%s", (String)"ResponseParser_13", (String)"ebg-receipt-banks-hrxjb-dc", (Object[])new Object[0]), succ_flag) + String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u7801\uff1a%s", (String)"ResponseParser_14", (String)"ebg-receipt-banks-hrxjb-dc", (Object[])new Object[0]), ret_code) + String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u4fe1\u606f%s", (String)"ResponseParser_15", (String)"ebg-receipt-banks-hrxjb-dc", (Object[])new Object[0]), ret_info + ext_info));
        }
        if (!"0000".equals(ret_code)) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25,\u672a\u80fd\u6b63\u5e38\u8fd4\u56de\u3002 \u6210\u529f\u6807\u5fd7%s", (String)"ResponseParser_13", (String)"ebg-receipt-banks-hrxjb-dc", (Object[])new Object[0]), succ_flag) + String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u7801\uff1a%s", (String)"ResponseParser_14", (String)"ebg-receipt-banks-hrxjb-dc", (Object[])new Object[0]), ret_code) + String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u4fe1\u606f%s", (String)"ResponseParser_15", (String)"ebg-receipt-banks-hrxjb-dc", (Object[])new Object[0]), ret_info + ext_info));
        }
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"body");
        return JDomUtils.getUnNullChildElement((Element)body, (String)"file_name").getTextTrim();
    }

    public static List<FileInfo> fileDownloadAndparse(DownloadListTask task, String file_name) {
        ArrayList<FileInfo> fileInfos = new ArrayList(16);
        String accNo = task.getAccNo();
        LocalDate transDate = task.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        boolean downloadFlag = false;
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, task.getBankLoginId());
        String ftpPath = bankFtpProperties.getFtpPath();
        String tempPath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"HRXJB_DC", (String)accNo, (String)transDateStr);
        logger.info("\u6e56\u5357\u94f6\u884c\u94f6\u884c\u51c6\u5907\u53bb\u670d\u52a1\u5668\u4e0b\u8f7d\u6982\u8981\u6587\u4ef6:" + file_name);
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
            downloadFlag = ResponseParser.ftpDownload(StringUtils.isEmpty((String)ftpPath) ? "/" : ftpPath, file_name, tempPath);
        } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
            BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
            downloadFlag = bankReceiptApiUtil.downloadReceiptFileWithPath(bankFtpProperties.getFrontProxyPath(), file_name, tempPath);
        }
        if (!downloadFlag) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u5728\u6e56\u5357\u94f6\u884c\u94f6\u884c\u63a8\u9001\u76ee\u5f55\u6ca1\u6709\u627e\u5230%s\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u94f6\u884c\u63a8\u9001\u8def\u5f84\u4e0b\u662f\u5426\u542b\u6709\u6b64\u6587\u4ef6\u3002\u82e5\u6709\u6b64\u6587\u4ef6\uff0c\u8bf7\u6838\u5bf9\u914d\u7f6e\u7684SFTP\u8def\u5f84\u662f\u5426\u4e3a\u94f6\u884c\u7684\u63a8\u9001\u8def\u5f84\u3002", (String)"ResponseParser_18", (String)"ebg-receipt-banks-hrxjb-dc", (Object[])new Object[0]), file_name));
        }
        logger.info("\u4e0b\u8f7d\u6587\u4ef6" + file_name + "\u6210\u529f..");
        File sourceFile = FileCommonUtils.getFileByPath((String)(tempPath + File.separator + file_name));
        fileInfos = ResponseParser.parseFileContent(sourceFile);
        return fileInfos;
    }

    private static List<FileInfo> parseFileContent(File sourceFile) {
        ArrayList<FileInfo> fileInfos;
        block32: {
            fileInfos = new ArrayList<FileInfo>();
            if (sourceFile.exists()) {
                try (FileInputStream totalFileStream = new FileInputStream(sourceFile);
                     BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)totalFileStream, "GBK"));){
                    String firstLine = bufferedReader.readLine();
                    logger.info("\u8bfb\u53d6\u6982\u8981\u6587\u4ef6\u7b2c\u4e00\u884c\uff1a{}", (Object)firstLine);
                    String fileContent = "";
                    while ((fileContent = bufferedReader.readLine()) != null) {
                        String host_serial_no = fileContent.split("\\|")[5];
                        String crdr_flag = fileContent.split("\\|")[23];
                        String amt = fileContent.split("\\|")[24];
                        FileInfo info = new FileInfo();
                        info.setHOST_SERIAL_NO(host_serial_no);
                        info.setCRDR_FLAG(crdr_flag);
                        info.setAMT(amt);
                        fileInfos.add(info);
                    }
                    ((InputStream)totalFileStream).close();
                    logger.info("\u8bfb\u53d6\u6982\u8981\u6587\u4ef6" + sourceFile + "\u5b8c\u6210");
                    break block32;
                }
                catch (Exception e) {
                    throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u6982\u8981\u6587\u4ef6%s\u5f02\u5e38\u3002", (String)"ResponseParser_19", (String)"ebg-receipt-banks-hrxjb-dc", (Object[])new Object[0]), sourceFile), (Throwable)e);
                }
                finally {
                    boolean isDelete = sourceFile.delete();
                    if (isDelete && !sourceFile.exists()) {
                        logger.info("\u6982\u8981\u6587\u4ef6" + sourceFile + "\u5220\u9664\u6210\u529f");
                    }
                }
            }
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u6982\u8981\u6587\u4ef6%s\u4e0d\u5b58\u5728\u3002\u8bf7\u548c\u94f6\u884c\u786e\u8ba4\u63a8\u9001\u8def\u5f84\uff0c\u548c\u94f6\u884c\u662f\u5426\u63a8\u9001\u6587\u4ef6", (String)"ResponseParser_20", (String)"ebg-receipt-banks-hrxjb-dc", (Object[])new Object[0]), sourceFile));
        }
        return fileInfos;
    }

    public static String[][] parseTwoDimensionalArray(String serial_record, int recordNum, int fieldNum) {
        String[][] twoArray = new String[recordNum][fieldNum];
        String[] allrecord = StringUtils.split((String)serial_record, (String)"|");
        for (int i = 0; i < recordNum; ++i) {
            for (int j = 0; j < fieldNum; ++j) {
                twoArray[i][j] = allrecord[(i + 1) * fieldNum + j];
            }
        }
        return twoArray;
    }

    private static boolean ftpDownload(String ftpPath, String orgFileName, String destFolder) {
        ChannelSftp sftp = null;
        boolean downloadFlag = false;
        try {
            Vector vector;
            if (SFTPUtils.getInstance().isAbort(sftp)) {
                sftp = SFTPUtils.getInstance().getSftp();
            }
            if (sftp != null && Objects.nonNull(vector = sftp.ls(ftpPath)) && vector.size() > 0) {
                for (Object o : vector) {
                    ChannelSftp.LsEntry file = (ChannelSftp.LsEntry)o;
                    if (!file.getFilename().equals(orgFileName)) continue;
                    downloadFlag = SFTPUtils.getInstance().downloadSingleFile(ftpPath, orgFileName, destFolder, sftp);
                }
            }
        }
        catch (Exception e) {
            try {
                String msg = ErrorMsgUtil.getSFTPErrorMSG((String)"", (String)e.getMessage());
                throw new ReceiptException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                SFTPUtils.getInstance().close(sftp);
                throw throwable;
            }
        }
        SFTPUtils.getInstance().close(sftp);
        return downloadFlag;
    }
}

