/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.icbc.opa.service.receipt;

import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.core.utils.GZFileUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoJsonService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public EBCReceiptInfoJsonService receiptInfoJsonService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.receiptInfoJsonService = (EBCReceiptInfoJsonService)SpringContextUtil.getBean(EBCReceiptInfoJsonService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        String bankLogin;
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        if (status.intValue() != TaskStatus.DOWNLOADING.getId()) {
            return false;
        }
        if (!RequestContextUtils.receiptFormatIsFile() && !FileCommonUtils.isTestEnv()) {
            return false;
        }
        String bankVersion = EBContext.getContext().getBankVersionID();
        return !RequestContextUtils.isSupportBatchDownloadByBankLogin((String)bankVersion, (String)(bankLogin = EBContext.getContext().getBankLoginID()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        boolean isToday = request.getTransDate().isEqual(LocalDate.now());
        if (isToday) {
            BankReceiptHandleResponseEB bankReceiptHandleResponseEB;
            String transDateStr = request.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE);
            String accNo = request.getAccNo();
            String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)request.getBankVersionId(), (String)accNo, (String)transDateStr);
            ChannelSftp sftp = null;
            try {
                BankFtpProperties ftpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, request.getBankLoginId());
                if (ftpProperties.getReceiptAchieveWay().equals("sftp") && SFTPUtils.getInstance().isAbort(sftp)) {
                    sftp = SFTPUtils.getInstance().getSftp();
                }
                ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(1);
                for (DownloadListDetail detail : downloadListDetails) {
                    if (detail.getUploadFlag().intValue() == UploadStatusEnum.UPLOAD_SUCCESS.getId()) {
                        result.add(detail);
                        continue;
                    }
                    result.addAll(this.doTodayTask(detail, bakFilePath, sftp, ftpProperties));
                }
                bankReceiptHandleResponseEB = BankReceiptHandleResponseEB.success(result);
            }
            catch (Throwable throwable) {
                SFTPUtils.getInstance().close(sftp);
                throw throwable;
            }
            SFTPUtils.getInstance().close(sftp);
            return bankReceiptHandleResponseEB;
        }
        return BankReceiptHandleResponseEB.success((Object)downloadListDetails);
    }

    public List<DownloadListDetail> doTodayTask(DownloadListDetail detail, String bakFilePath, ChannelSftp sftp, BankFtpProperties ftpProperties) {
        File zipFile;
        String accNo = detail.getAccNo();
        String zipName = detail.getFileName();
        String sftp_path = ftpProperties.getFtpPath();
        sftp_path = EBGStringUtils.isNotEmpty((String)sftp_path) ? sftp_path : "/";
        boolean flag = false;
        List fileList = new ArrayList(1);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(1);
        if (ftpProperties.getReceiptAchieveWay().equals("sftp")) {
            flag = SFTPUtils.getInstance().downloadSingleFile(sftp_path, zipName, bakFilePath, sftp);
        }
        if (ftpProperties.getReceiptAchieveWay().equals("bank_login")) {
            BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, detail.getTransDate());
            flag = bankReceiptApiUtil.downloadReceiptFile(zipName, bakFilePath);
        }
        if (flag && (zipFile = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + zipName))).exists()) {
            fileList = FileCommonUtils.readZipFiles((String)zipFile.getPath());
            if (GZFileUtils.unZipFiles((String)zipFile.getPath(), (String)bakFilePath)) {
                for (String receiptFileName : fileList) {
                    String newFileName;
                    File receiptFile = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + receiptFileName));
                    if (!FileCommonUtils.moveFile((File)receiptFile, (String)bakFilePath, (String)(newFileName = "today_" + receiptFile.getName()))) continue;
                    DownloadListDetail downloadListDetail = new DownloadListDetail();
                    downloadListDetail.setFileLink(zipName);
                    downloadListDetail.setFileName(newFileName);
                    result.add(downloadListDetail);
                    FileCommonUtils.deleteFile((File)receiptFile);
                }
                FileCommonUtils.deleteFile((File)zipFile);
            }
        }
        return result;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "ICBC_OPA_BankReceiptDownload";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u5f00\u653e\u5e73\u53f0\u7248\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d\u3002", (String)"BankReceiptDownloadImpl_0", (String)"ebg-receipt-banks-icbc-opa", (Object[])new Object[0]);
    }
}

