/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cdcb.cms.service;

import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoJsonService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public EBCReceiptInfoJsonService receiptInfoJsonService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.receiptInfoJsonService = (EBCReceiptInfoJsonService)SpringContextUtil.getBean(EBCReceiptInfoJsonService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        String bankVersionId = request.getBankVersionId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        long taskId = request.getTaskId();
        String bankLogin = request.getBankLoginId();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
        ChannelSftp sftp = null;
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp") && SFTPUtils.getInstance().isAbort(sftp)) {
            sftp = SFTPUtils.getInstance().getSftp(bankLogin);
        }
        boolean isLastFile = false;
        for (int i = 0; i < downloadListDetails.size(); ++i) {
            if (i == downloadListDetails.size() - 1) {
                isLastFile = true;
            }
            DownloadListDetail downloadListDetail = (DownloadListDetail)downloadListDetails.get(i);
            List<DownloadListDetail> details = this.download(downloadListDetail, bakFilePath, accNo, transDate, bankFtpProperties, sftp, isLastFile);
            result.addAll(details);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public List<DownloadListDetail> download(DownloadListDetail detail, String bakFilePath, String accNo, LocalDate transDate, BankFtpProperties bankFtpProperties, ChannelSftp sftp, boolean isLastFile) {
        String fileName = detail.getFileLink();
        String newFileName = detail.getFileName();
        String date = transDate.toString().replace("-", "");
        String ftpPath = File.separator + accNo + File.separator + date;
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        try {
            boolean flag = false;
            if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                String sftpPath = EBGStringUtils.isEmpty((String)bankFtpProperties.getFtpPath()) ? ftpPath : bankFtpProperties.getFtpPath();
                flag = SFTPUtils.getInstance().downloadSingleFile(sftpPath, fileName, bakFilePath, sftp);
            } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
                BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
                flag = bankReceiptApiUtil.downloadReceiptFile(fileName, bakFilePath);
            }
            if (flag) {
                File saveFile = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + fileName));
                FileCommonUtils.moveFile((File)saveFile, (String)bakFilePath, (String)newFileName);
                logger.info("\u6210\u90fd\u94f6\u884c\u94f6\u884c\u56de\u5355\u6587\u4ef6 {} \u4e0b\u8f7d\u5b8c\u6210\u3002", (Object)detail.getFileName());
                result.add(detail);
            }
        }
        catch (Exception e) {
            isLastFile = true;
            throw new ReceiptException((Throwable)e);
        }
        finally {
            if (isLastFile && bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                SFTPUtils.getInstance().close(sftp);
            }
        }
        return result;
    }

    public String getDeveloper() {
        return "Five Six Seven";
    }

    public String getBizCode() {
        return "BankReceiptDownload";
    }

    public String getBizDesc() {
        return "";
    }
}

