/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cdcb.cms.service.api;

import java.time.format.DateTimeFormatter;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.cdcb.cms.utils.Packer;
import kd.ebg.receipt.banks.cdcb.cms.utils.Parser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import org.jdom2.Element;

public class ReceiptRequestImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptRequestImpl.class);

    public String pack(BankReceiptRequest request) {
        String transDate = request.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        Element ap = Packer.creatHead("00220122C0245", Sequence.gen18Sequence());
        Element body = JDomUtils.addChild((Element)ap, (String)"body");
        JDomUtils.addChild((Element)body, (String)"tranType", (String)"1001");
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"currency", (String)request.getAcnt().getCurrency());
        JDomUtils.addChild((Element)body, (String)"startDate", (String)transDate);
        JDomUtils.addChild((Element)body, (String)"endDate", (String)transDate);
        Element array = JDomUtils.addChild((Element)body, (String)"array");
        String seqNo = request.getRequestStr();
        logger.info("\u6b63\u5728\u8bf7\u6c42\u7684\u56de\u5355\u6d41\u6c34\u53f7\u4e3a{}", (Object)seqNo);
        Element dto = JDomUtils.addChild((Element)array, (String)"dto");
        JDomUtils.addChild((Element)dto, (String)"seqNo", (String)seqNo);
        String msg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)RequestContextUtils.getCharset());
        return Packer.createCommonMsg(msg);
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String s) {
        Element element = Parser.getResponseElement(s);
        Parser.resSuccessCheck(element);
        Element body = element.getChild("body");
        String fileName = body.getChildTextTrim("file_name");
        logger.info("\u56de\u5355\u6587\u4ef6\u540d\u4e3a{}", (Object)fileName);
        return BankReceiptResponseEB.success((Object)fileName);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "00220122C0245";
    }

    public String getBizDesc() {
        return "";
    }
}

